/**
 * 
 */
package eu.qimpress.ide.analysis.reliability.launch;

import org.eclipse.debug.ui.AbstractLaunchConfigurationTabGroup;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.ui.tabs.AlternativeSelectionListener;
import eu.qimpress.ide.backbone.core.ui.tabs.QImpressAlternativeEvaluationSelectionTab;
import eu.qimpress.ide.backbone.core.ui.tabs.QImpressAlternativeSelectionTab;
import eu.qimpress.ide.backbone.core.ui.tabs.QImpressUsageModelSelectionTab;

/**
 * The implementation class for the configuration tab group for reliability analysis.
 * @author Mauro Luigi Drago, Andrea Ciancone
 *
 */
public class ReliabilityLaunchConfigurationTabGroup extends AbstractLaunchConfigurationTabGroup {
	@Override
	public void createTabs(ILaunchConfigurationDialog dialog, String mode) {
		final QImpressAlternativeSelectionTab qImpressAlternativeSelectionTab = new QImpressAlternativeSelectionTab();
		final QImpressUsageModelSelectionTab qImpressUsageModelSelectionTab = new QImpressUsageModelSelectionTab();
		final ReliabilityLaunchConfigurationTab reliabilityLaunchConfigurationTab = new ReliabilityLaunchConfigurationTab();
		qImpressAlternativeSelectionTab.addAlternativeSelectionListener(new AlternativeSelectionListener() {
			public void alternativeSelected(IQAlternative alternative) {
				qImpressUsageModelSelectionTab.setSelectedAlternative(alternative);
			}
		});
		ILaunchConfigurationTab[] tabs = new ILaunchConfigurationTab[] {
				qImpressAlternativeSelectionTab,
				qImpressUsageModelSelectionTab,
				new QImpressAlternativeEvaluationSelectionTab(),
				reliabilityLaunchConfigurationTab
			};
		setTabs(tabs);
	}
}