package eu.qimpress.ide.analysis.reliability.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

import eu.qimpress.ide.analysis.reliability.Activator;
import eu.qimpress.ide.analysis.reliability.jobs.ReliabilityAnalysis;

/**
 * The implementation class for the configuration tab for reliability analysis.
 * @author Mauro Luigi Drago, Andrea Ciancone
 *
 */
public class ReliabilityLaunchConfigurationTab extends AbstractLaunchConfigurationTab {
	/** The name of the tab */
	private static final String TAB_NAME = "Analysis parameters";

	private Text resultPrecisionDigit;
//	/** The control holding the output folder path */
//	private Text outputFolderText;
	
	/**
	 * Default constructor.
	 */
	public ReliabilityLaunchConfigurationTab() {
	}

	@Override
	public void createControl(Composite parent) {
		// Create the top composite
		Composite topControl = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		layout.numColumns = 3;
		topControl.setLayout(layout);
		setControl(topControl);

		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalSpan = 2;

		Label precision = new Label(topControl, SWT.NULL);
		precision.setText("Number of decimal digit precision");
		resultPrecisionDigit = new Text(topControl, SWT.NULL);
		resultPrecisionDigit.setLayoutData(gd);
		resultPrecisionDigit.setEditable(true);

		
//		Label l = new Label(topControl, SWT.NULL);
//		l.setText("Output Folder");
//		outputFolderText = new Text(topControl, SWT.NULL);
//		outputFolderText.setLayoutData(gd);
//		outputFolderText.setEditable(false);
//		outputFolderText.setText("");
	}

	@Override
	public String getName() {
		return TAB_NAME;
	}

	@Override
	public void initializeFrom(ILaunchConfiguration configuration) {
		try {
			resultPrecisionDigit.setText(configuration.getAttribute(
				ReliabilityLaunchConfiguration.RESULT_PRECISION,
				defaultReliabilityResultPrecision()));
		} catch (CoreException e) {
			Dialog d = new ErrorDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 
				"Configuration Error", "Error while configuring launch.", new Status(IStatus.ERROR, Activator.PLUGIN_ID, e.getMessage(), e), 0);
			d.open();
		}
	}

	@Override
	public void performApply(ILaunchConfigurationWorkingCopy configuration) {
		configuration.setAttribute(
				ReliabilityLaunchConfiguration.RESULT_PRECISION,
				resultPrecisionDigit.getText());
	}

	@Override
	public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
		configuration.setAttribute(
				ReliabilityLaunchConfiguration.RESULT_PRECISION,
				defaultReliabilityResultPrecision());
	}

	private String defaultReliabilityResultPrecision() {
		return new Integer(ReliabilityAnalysis.DEFAULT_RESULT_PRECISION).toString();
	}
}