package eu.qimpress.ide.analysis.reliability.jobs.prism;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

import org.apache.log4j.Logger;

/**
 * Redirects an input stream onto a logging stream.
 * @author Mauro Luigi Drago
 *
 */
public class StreamRedirector extends Thread {
	
	public static enum Type {NORMAL, ERROR};
	
	/** The input stream to redirect */
	private InputStream is;
	
	/** The logger */
	private Logger logger;
	
	/** The stream type */
	private Type type;

	public StreamRedirector(InputStream is, Logger logger, Type type) {
		super();
		
		this.is = is;
		this.logger = logger;
	}

	@Override
	public void run() {
		InputStreamReader reader = new InputStreamReader(is);
		BufferedReader br = new BufferedReader(reader);
		try {
			String line = null;
			while ((line = br.readLine()) != null) {
				if (type == Type.ERROR) logger.error("Error -> " + line);
				else logger.info("Output -> " + line);
			}
		} catch (IOException e) {
			logger.error("Unable to read from stream : " + e.getMessage());
		} finally {
			try {
				br.close();
				reader.close();
			} catch (IOException e) {
				logger.error("Unable to close stream");
			}
		}
	}
}
