package eu.qimpress.ide.analysis.reliability.jobs.prism;

import java.io.File;

import de.uka.ipd.sdq.workflow.AbstractJobConfiguration;

public class PrismAnalysisJobConf extends AbstractJobConfiguration {
	/** The location of the Prism model */
	private File modelFile;
	
	/** The location of the Prism properties file */
	private File propsFile;
	
	/** The prism executable */
	private File prismExecutable;
	
	/** The file used to save the analysis results */
	private File outputFile;
	
	/** The temporary directory */
	private File tempDir;

	public PrismAnalysisJobConf() {
	}

	/**
	 * Gets the file containing the Prism model.
	 * @return the file.
	 */
	public File getModelFile() {
		return modelFile;
	}

	/**
	 * Sets the file containing Prism model.
	 * @param modelFile the file.
	 */
	public void setModelFile(File modelFile) {
		this.modelFile = modelFile;
	}

	/**
	 * Gets the file containing the Prism properties.
	 * @return the file.
	 */
	public File getPropsFile() {
		return propsFile;
	}

	/**
	 * Sets the file containing the Prism properties.
	 * @param propsFile the file.
	 */
	public void setPropsFile(File propsFile) {
		this.propsFile = propsFile;
	}

	/**
	 * Gets the Prism executable.
	 * @return the folder.
	 */
	public File getPrismExecutable() {
		return prismExecutable;
	}

	/**
	 * Sets the Prism executable.
	 * @param prismBaseFolder the folder.
	 */
	public void setPrismExecutable(File prismExecutable) {
		this.prismExecutable = prismExecutable;
	}

	/**
	 * Gets the file used to output the analysis results.
	 * @return the file.
	 */
	public File getOutputFile() {
		return outputFile;
	}

	/**
	 * Sets the file used to output the analysis results.
	 * @return the file.
	 */
	public void setOutputFile(File outputFile) {
		this.outputFile = outputFile;
	}

	/**
	 * Gets the temporary directory.
	 * @return the directory.
	 */
	public File getTempDir() {
		return tempDir;
	}

	/**
	 * Sets the temporary directory.
	 * @param tempDir the directory.
	 */
	public void setTempDir(File tempDir) {
		this.tempDir = tempDir;
	}

	@Override
	public String getErrorMessage() {
		if (modelFile == null) return "No input Prism model specified";
		if (propsFile == null) return "No input Prism properties file specified";
		if (outputFile == null) return "No output file specified";
		
		if (tempDir == null) return "No temporary directory specified";
		if (!tempDir.exists() || !tempDir.isDirectory()) return "Invalid temporary directory specified "+tempDir.getAbsolutePath();
		
		if (prismExecutable == null) return "No Prism executable specified";
		if (!prismExecutable.exists() || !prismExecutable.isFile()) return "Invalid Prism executable specified "+prismExecutable.getAbsolutePath();
		
		return null;
	}

	@Override
	public void setDefaults() {
		// nothing to do
	}
}
