package eu.qimpress.ide.analysis.reliability.jobs.acceleo;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.resources.IFolder;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;

import de.uka.ipd.sdq.workflow.AbstractJobConfiguration;

/**
 * A bean containing configuration parameters for an Acceleo M2T tranformation.
 * @author Mauro Luigi Drago
 *
 */
public class AcceleoTransformationJobConf extends AbstractJobConfiguration {
	
	/** The helper class created by Acceleo to run transformations */
	private Class<?> acceleoGeneratorClass;
	
	/** The name of the method of the generator class to run the transformation */
	private String generatorMethodName;
	
	/** The URI of the input model */
	private URI inputModel;
	
	/** The folder containing the transformation outputs*/
	private IFolder outputFolder;
	
	/** The arguments to pass to the transformation */
	private List<String> arguments = new ArrayList<String>();

	/**
	 * Gets the helper class to run the transformation.
	 * @return the helper class.
	 */
	public Class<?> getAcceleoGeneratorClass() {
		return acceleoGeneratorClass;
	}

	/**
	 * Sets the helper class to run the tranformation.
	 * @param acceleoGeneratorClass the helper class.
	 */
	public void setAcceleoGeneratorClass(Class<?> acceleoGeneratorClass) {
		this.acceleoGeneratorClass = acceleoGeneratorClass;
	}

	/**
	 * Gets the URI of the input model.
	 * @return the URI.
	 */
	public URI getInputModel() {
		return inputModel;
	}

	/**
	 * Sets the URI of the input model.
	 * @param inputModel the URI.
	 */
	public void setInputModel(URI inputModel) {
		this.inputModel = inputModel;
	}

	/**
	 * Gets the output folder.
	 * @return the output folder.
	 */
	public IFolder getOutputFolder() {
		return outputFolder;
	}

	/**
	 * Sets the output folder.
	 * @param outputFolder the output folder.
	 */
	public void setOutputFolder(IFolder outputFolder) {
		this.outputFolder = outputFolder;
	}

	/**
	 * Gets the arguments to pass to the transformation.
	 * @return the arguments.
	 */
	public List<String> getArguments() {
		return arguments;
	}

	/**
	 * Sets the arguments to pass to the tranformation.
	 * @param arguments the arguments.
	 */
	public void setArguments(List<String> arguments) {
		this.arguments = arguments;
	}

	/**
	 * Gets the name of the method of the GeneratorClass to run the transformation.
	 * @return the name of the method.
	 */
	public String getGeneratorMethodName() {
		return generatorMethodName;
	}

	/**
	 * Sets the name of the method of the GeneratorClass to run the transformation.
	 * @param generatorMethodName the name of the method.
	 */
	public void setGeneratorMethodName(String generatorMethodName) {
		this.generatorMethodName = generatorMethodName;
	}

	@Override
	public String getErrorMessage() {
		if (inputModel == null ) return "No input model specified";
		//TODO add checks here for file existence
		
		if (outputFolder == null) return "No output folder specified";
		
		// check that generator class has been specified
		if (acceleoGeneratorClass == null)
			return "No generator class specified";
		
		if (generatorMethodName == null)
			return "No generator method specified";
		
		// check that generator class has the required generate method
		try {
			Class<?>[] params = {
				Monitor.class	
			};
			acceleoGeneratorClass.getMethod(generatorMethodName, params);
		} catch (Exception e) {
			return "Invalid generator method specified : " + e.getMessage();
		}
		
		return null;
	}

	@Override
	public void setDefaults() {
		// nothing to do here
	}
}
