package eu.qimpress.ide.analysis.reliability.jobs;

import java.util.ArrayList;
import java.util.List;

/**
 * Exception raised in case of model validation failure. It contains a list of the model errors
 * @author Andrea Ciancone
 */
public class ValidationException extends java.lang.Exception {
	private static final long serialVersionUID = -7935109402720459973L;
	public List<String> errors = new ArrayList<String>();
	private String message;
	public ValidationException(String message) {
		this.message = message;
	}
	public ValidationException(String message, List<String> errors) {
		this(message);
		this.errors = errors;
	}
	@Override
	public String getMessage() {
		return this.message;
	}
	public void printErrors() {
		for(String err : errors) {
			System.err.println(err);
		}
	}
}
