package eu.qimpress.ide.analysis.reliability.jobs;

import de.uka.ipd.sdq.workflow.AbstractJobConfiguration;
import eu.qimpress.ide.analysis.reliability.launch.ReliabilityLaunchConfiguration;

public class SysCallAnalysisJobConf extends AbstractJobConfiguration {
	/** The root reliability analysis configuration */
	private ReliabilityLaunchConfiguration reliabilityConf;
	
	/** The identifier of the usage scenario to analyze */
	private String usageScenarioId;
	
	/** True if Prism models should be beautified*/
	private boolean beautifyPrismModels;

	public SysCallAnalysisJobConf() {
	}
	
	/**
	 * Gets the root reliability analysis configuration.
	 * @return the root configuration.
	 */
	public ReliabilityLaunchConfiguration getReliabilityConf() {
		return reliabilityConf;
	}

	/**
	 * Sets the root reliability analysis configuration.
	 * @param reliabilityConf the root configuration.
	 */
	public void setReliabilityConf(ReliabilityLaunchConfiguration reliabilityConf) {
		this.reliabilityConf = reliabilityConf;
	}

	/**
	 * Gets the identifier of the usage scenario to analyze.
	 * @return the identifier.
	 */
	public void setUsageScenarioId(String usageScenarioId) {
		this.usageScenarioId = usageScenarioId;
	}

	/**
	 * Gets the identifier of the usage scenario to analyze.
	 * @return the identifier.
	 */
	public String getUsageScenarioId() {
		return usageScenarioId;
	}

	/**
	 * Checks if the beautification of Prism models is enabled.
	 * @return true if enabled.
	 */
	public boolean isBeautifyPrismModels() {
		return beautifyPrismModels;
	}

	/**
	 * Enables/disables the beautification of Prism models.
	 * @param beautifyPrismModels true if should be enabled.
	 */
	public void setBeautifyPrismModels(boolean beautifyPrismModels) {
		this.beautifyPrismModels = beautifyPrismModels;
	}

	
	@Override
	public String getErrorMessage() {
		if (reliabilityConf == null) return "No root reliability analysis configuration specified";
		
		return reliabilityConf.getErrorMessage();
	}

	@Override
	public void setDefaults() {
		beautifyPrismModels = false;
	}
}
