package eu.qimpress.ide.analysis.reliability.jobs;

import java.util.HashMap;
import java.util.Set;

import eu.qimpress.ide.analysis.reliability.rmc.core.RMC;
import eu.qimpress.ide.analysis.reliability.rmc.mat.Solver;
import eu.qimpress.ide.analysis.reliability.rmc.mat.TargetVariableNotFoundException;

public class ReliabilityAnalysisResult {
	private final RMC rmc;
	private final Solver solver;

	public ReliabilityAnalysisResult(RMC rmc, Solver solver) {
		this.rmc = rmc;
		this.solver = solver;
	}
	public Set<String> getEquations() {
		return rmc.getEquations();
	}
	public HashMap<String, Double> getAssignment() {
		return solver.getCurrentAssignment();
	}
	public double getReliability() {
		try {
			return solver.getValue(rmc.getInitialModule().getName()+rmc.getInitialModule().getStart().getName());
		} catch (TargetVariableNotFoundException e) {
			return 0;
		}
	}
	public double getMSV() {
		return solver.getMSV();
	}
	public long getIterations() {
		return solver.getNumIterations();
	}
}
