package eu.qimpress.ide.analysis.reliability.jobs;

import klaper.core.CorePackage;

import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EPackage;

import de.uka.ipd.sdq.workflow.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import eu.qimpress.dtmc.DtmcPackage;

public class PrepareReliabiltyBlackboardPartionJob 
	implements IJob, IBlackboardInteractingJob<MDSDBlackboard> {
	
	/** The Class logger */
	private static final Logger logger = Logger.getLogger(PrepareReliabiltyBlackboardPartionJob.class);
	
	/** The job name */
	private static final String JOB_NAME = "Prepare Reliability Blackboard Partions";
	
	/** The packages needed by the reliability models partition*/
	public static final EPackage[] RELIABILITY_EPACKAGES = new EPackage[] {
		CorePackage.eINSTANCE,
		DtmcPackage.eINSTANCE
	};
	
	/** The blackboard */
	private MDSDBlackboard blackboard;
	
	/** The job configuration */
	private PrepareReliabilityBlackboardPartitionConf conf;
	
	public PrepareReliabiltyBlackboardPartionJob(PrepareReliabilityBlackboardPartitionConf conf) {
		this.conf = conf;
	}
	
	/**
	 * Checks that the job can be executed. 
	 * @throws JobFailedException if the job could not be executed
	 */
	private void check() throws JobFailedException {
		if (!conf.isValid()) throw new JobFailedException(conf.getErrorMessage());
	}

	@Override
	public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
		check();
		
		// Create and add the klaper model partition
		logger.debug("Creating Reliability Model Partition");
		ResourceSetPartition myPartion = new ResourceSetPartition();
		blackboard.addPartition(conf.getPartitionName(), myPartion);
		
		logger.debug("Initialising Reliability EPackages");
		myPartion.initialiseResourceSetEPackages(RELIABILITY_EPACKAGES);
	}

	@Override
	public String getName() {
		return JOB_NAME;
	}

	@Override
	public void rollback(IProgressMonitor monitor)
			throws RollbackFailedException {
		this.blackboard.removePartition(conf.getPartitionName());
	}

	@Override
	public void setBlackboard(MDSDBlackboard blackboard) {
		this.blackboard = blackboard;
	}

}
