package eu.qimpress.ide.analysis.reliability.jobs;

import de.uka.ipd.sdq.workflow.AbstractJobConfiguration;

public class PrepareReliabilityBlackboardPartitionConf extends AbstractJobConfiguration {
	
	/** The default partition name */
	public static final String DEFAULT_RELIABILITY_MODELS_PARTITION_ID = "eu.qimpress.reliability.partition";
	
	/** The name of the partition to create */
	private String partitionName;

	/**
	 * Gets the partition name.
	 * @return the name.
	 */
	public String getPartitionName() {
		return partitionName;
	}

	/**
	 * Sets the partition name.
	 * @param partitionName the name.
	 */
	public void setPartitionName(String partitionName) {
		this.partitionName = DEFAULT_RELIABILITY_MODELS_PARTITION_ID + ":" +partitionName;
	}

	@Override
	public String getErrorMessage() {
		if (partitionName == null) return "No partition name specified";
		if (partitionName.equals("")) return "Invalid partition name specified";
		
		return null;
	}

	@Override
	public void setDefaults() {
		partitionName = DEFAULT_RELIABILITY_MODELS_PARTITION_ID; 
	}
}
