package eu.qimpress.ide.analysis.reliability;

import org.eclipse.ocl.util.CollectionUtil;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

import eu.qimpress.samm.staticstructure.Interface;
import eu.qimpress.seff.AbstractAction;
import eu.qimpress.seff.StartAction;
import eu.qimpress.seff.StopAction;

public class SammUtility {

	public SammUtility() {
		super();
	}
	public static Set<Interface> inheritedInterfaces(Interface iface) {
		Set<Interface> reached = CollectionUtil.createNewSet();
		LinkedList<Interface> inheritedIface = new LinkedList<Interface>();
		inheritedIface.add(iface);
		while(inheritedIface.size()>0) {
			iface=inheritedIface.removeFirst();
			reached.add(iface);
			for (Interface inherited: iface.getInheritance()) {
				if(reached.contains(inherited)) continue;
				inheritedIface.addLast(inherited);				
			}
		}
		return reached;
	}
	public static Boolean isIntefaceHierarchyLoopFree(Interface iface) {
		HashSet<Interface> reached = new HashSet<Interface>();
		LinkedList<Interface> toAnalyze = new LinkedList<Interface>();
		toAnalyze.add(iface);
		while(toAnalyze.size()>0) {
			iface=toAnalyze.removeFirst();
			if(reached.contains(iface)) return false;
			reached.add(iface);
			for (Interface inherited: iface.getInheritance()) {
				toAnalyze.addLast(inherited);
			}
		}
		return true;
	}
	public static Boolean isStopActionReachable(AbstractAction self) {
		HashSet<AbstractAction> reached = new HashSet<AbstractAction>();
		while(true) {
			if(self==null) return false;
			if(self instanceof StopAction) return true;
			if(reached.contains(self)) return false;
			reached.add(self);
			self=self.getSuccessor_AbstractAction();
		}
	}
	public static Boolean isStartActionReachable(AbstractAction self) {
		HashSet<AbstractAction> reached = new HashSet<AbstractAction>();
		while(true) {
			if(self==null) return false;
			if(self instanceof StartAction) return true;
			if(reached.contains(self)) return false;
			reached.add(self);
			self=self.getPredecessor_AbstractAction();
		}
	}
}
