package eu.qimpress.ide.tradeoff.ahp;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;

import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.experimental.chart.swt.ChartComposite;

import Jama.Matrix;
import eu.qimpress.ide.tradeoff.ahp.AHPWizard.Qualities;
import eu.qimpress.resultmodel.AlternativeEvaluation;

public class ResultsPage extends WizardPage {
	public static final String PAGE_NAME = "AHP Analysis Results";

	private Matrix qualityMatrix;
	private Matrix[] valueMatrix;
	private boolean[] QualityInUse;

	private TableColumn[] dataTableColumns;
	/*
	 * private TableColumn responseTimeTableColumn; private TableColumn
	 * reliabilityTableColumn; private TableColumn costTableColumn; private
	 * TableColumn utilizationTableColumn;
	 */
	private TableColumn totalTableColumn;

	private ArrayList<AlternativeEvaluation> evaluations;
	private int numRes;
	private Composite topLevel;
	private double results[];
	DefaultCategoryDataset dataset;
	Button normalizeCheck;
	public boolean NORMALIZE = false;
	public Vector<String> stringCriteria;
	public Text txtfilename;
	// private double[][] rawResultMatrix;
	private TableColumn alternativeTableColumn;
	private Table resultBreakDownTable;
	private Composite globalParent;

	public JFreeChart chart;

	public Vector<Vector<String>> stringResults;

	private int currentNumberOfQualities;

	public ResultsPage(AHPDataPoint ahpDataPoint,
			ArrayList<AlternativeEvaluation> evaluations, boolean[] qualityInUse) {
		super(PAGE_NAME, "Interpet results", null);
		this.qualityMatrix = ahpDataPoint.getQualityMatrix();
		this.valueMatrix = ahpDataPoint.getValueMatrix();
		this.evaluations = evaluations;
		numRes = evaluations.size();
		results = new double[numRes];
		QualityInUse = qualityInUse;
	}

	public void setVisible(boolean b) {
		super.setVisible(b);
		updateAhpResults();
		globalParent.getParent().layout(true,true);
		globalParent.getParent().redraw();
	}

	public void createControl(Composite parent) {
		globalParent = parent;
		drawControl(QualityInUse);
	}

	public void drawControl(boolean[] qualityInUse2) {
		QualityInUse = qualityInUse2;
		Composite parent = globalParent;

		currentNumberOfQualities = 0;
		for (int i = 0; i < QualityInUse.length; i++) {
			if (QualityInUse[i])
				currentNumberOfQualities++;
		}

		if (topLevel != null)
			topLevel.dispose();

		topLevel = new Composite(parent, SWT.NONE);
		topLevel.setLayout(new GridLayout(1, false));

		dataset = new DefaultCategoryDataset();

		chart = ChartFactory.createStackedBarChart("AHP Analysis Results", // chart
				// title
				"Alternative Evaluations", // domain axis label
				"Values", // range axis label
				dataset, // data
				PlotOrientation.VERTICAL, // orientation
				true, // include legend
				true, // tooltips?
				false // URLs?
				);

		CategoryPlot plot = (CategoryPlot) chart.getPlot();
		plot.setBackgroundPaint(Color.lightGray);
		plot.setDomainGridlinePaint(Color.white);
		plot.setDomainGridlinesVisible(true);
		plot.setRangeGridlinePaint(Color.white);

		ChartComposite frame = new ChartComposite(topLevel, SWT.NONE, chart,
				true);
		GridData graphLayout = new GridData();
		graphLayout.grabExcessHorizontalSpace = true;
		graphLayout.grabExcessVerticalSpace = true;
		graphLayout.horizontalAlignment = SWT.FILL;
		graphLayout.verticalAlignment = SWT.FILL;
		frame.setLayoutData(graphLayout);

		Composite textAndGridResultsComposite = new Composite(topLevel,
				SWT.NONE);
		GridData gd1 = new GridData();
		gd1.grabExcessHorizontalSpace = true;
		gd1.horizontalAlignment = SWT.FILL;
		textAndGridResultsComposite.setLayoutData(gd1);
		textAndGridResultsComposite.setLayout(new GridLayout(2, false));

		/*
		 * Results grid
		 */
		{
			Composite rbtComp = new Composite(topLevel, SWT.NONE);
			GridData resultBreakDownTableCompositeLData = new GridData();
			resultBreakDownTableCompositeLData.grabExcessHorizontalSpace = true;
			resultBreakDownTableCompositeLData.horizontalAlignment = SWT.FILL;
			resultBreakDownTableCompositeLData.verticalAlignment = SWT.FILL;
			rbtComp.setLayoutData(resultBreakDownTableCompositeLData);
			TableColumnLayout tcl = new TableColumnLayout();
			rbtComp.setLayout(tcl);

			resultBreakDownTable = new Table(rbtComp, SWT.NONE);
			/*
			 * FillLayout resultBreakDownTableLayout = new FillLayout(
			 * org.eclipse.swt.SWT.HORIZONTAL);
			 * resultBreakDownTable.setLayout(resultBreakDownTableLayout);
			 */
			{
				alternativeTableColumn = new TableColumn(resultBreakDownTable,
						SWT.NONE);
				alternativeTableColumn.setText("Alternative");
				TableItem tableItem = new TableItem(resultBreakDownTable, 0);
				tableItem.setText("Bla");

			}

			{
				totalTableColumn = new TableColumn(resultBreakDownTable,
						SWT.NONE);
				totalTableColumn.setText("Total");
			}

			dataTableColumns = new TableColumn[currentNumberOfQualities];
			for (int i = 0; i < currentNumberOfQualities; i++) {
				dataTableColumns[i] = new TableColumn(resultBreakDownTable,
						SWT.NONE);
				dataTableColumns[i].setText("Utilization");
			}
			resultBreakDownTable.setHeaderVisible(true);
			resultBreakDownTable.setLinesVisible(true);

			tcl.setColumnData(alternativeTableColumn, new ColumnWeightData(20));
			tcl.setColumnData(totalTableColumn, new ColumnWeightData(10));
			for (int i = 0; i < currentNumberOfQualities; i++) {
				tcl
						.setColumnData(dataTableColumns[i],
								new ColumnWeightData(16));
			}

		}

		normalizeCheck = new Button(topLevel, SWT.CHECK);
		normalizeCheck.setText("Normalize values");
		normalizeCheck.addSelectionListener(new NormalizeBtnListener());

		updateAhpResults();

		Composite fileBrowser = new Composite(topLevel, SWT.NONE);
		GridData fileBrowserGridData = new GridData();
		fileBrowserGridData.grabExcessHorizontalSpace = true;
		fileBrowserGridData.horizontalAlignment = SWT.FILL;
		fileBrowser.setLayoutData(fileBrowserGridData);
		fileBrowser.setLayout(new GridLayout(3, false));
		Label lblExport = new Label(fileBrowser, SWT.NONE);
		lblExport.setText("Export results as:");
		txtfilename = new Text(fileBrowser, SWT.SINGLE | SWT.BORDER);
		GridData txtfilenameGridData = new GridData();
		txtfilenameGridData.grabExcessHorizontalSpace = true;
		txtfilenameGridData.horizontalAlignment = SWT.FILL;
		txtfilename.setLayoutData(txtfilenameGridData);
		Button btnBrowse = new Button(fileBrowser, SWT.PUSH);
		btnBrowse.setText("Browse");
		btnBrowse.addSelectionListener(new BrowseBtnListener());

		parent.layout(true, true);
		parent.pack();
		parent.redraw();
		setControl(topLevel);
		setPageComplete(true);
	}

	class BrowseBtnListener implements SelectionListener {

		@Override
		public void widgetDefaultSelected(SelectionEvent e) {
			widgetSelected(e);

		}

		@Override
		public void widgetSelected(SelectionEvent e) {
			FileDialog dlg = new FileDialog(topLevel.getShell(), SWT.SAVE);
			String[] filterExt = { "*.html" };
			String[] filterNam = { "HTML Files" };
			dlg.setFilterExtensions(filterExt);
			dlg.setFilterNames(filterNam);
			dlg.setText("Export Results As:");
			String selected = dlg.open();
			if (selected != null) {
				txtfilename.setText(selected);
			}

		}

	}

	class NormalizeBtnListener implements SelectionListener {

		@Override
		public void widgetDefaultSelected(SelectionEvent e) {
			widgetSelected(e);
		}

		@Override
		public void widgetSelected(SelectionEvent e) {

			NORMALIZE = normalizeCheck.getSelection();
			updateAhpResults();
		}

	}

	private Matrix normalize(Matrix m) {
		Matrix ret = m.copy();
		for (int j = 0; j < ret.getColumnDimension(); j++) {
			double sum = 0;
			for (int i = 0; i < ret.getRowDimension(); i++)
				sum += ret.get(i, j);
			for (int i = 0; i < ret.getRowDimension(); i++)
				ret.set(i, j, ret.get(i, j) / sum);
		}
		return ret;
	}

	private Matrix normalizeQM(Matrix m) {
		Matrix ret = m.copy();
		for (int j = 0; j < ret.getColumnDimension(); j++) {
			double sum = 0;
			for (int i = 0; i < ret.getRowDimension(); i++) {
				if (QualityInUse[i] && QualityInUse[j])
					sum += ret.get(i, j);
			}
			for (int i = 0; i < ret.getRowDimension(); i++) {
				if (QualityInUse[i] && QualityInUse[j])
					ret.set(i, j, ret.get(i, j) / sum);
			}
		}
		return ret;
	}

	private double[] normalize(double[] arr) {
		double total = 0;
		for (double d : arr) {
			total += d;
		}
		for (int i = 0; i < arr.length; i++) {
			arr[i] /= total;
		}

		return arr;

	}

	private double[] normalizeAndFilter(double[] arr) {
		double total = 0;
		for (int i = 0; i < arr.length; i++) {
			if (QualityInUse[i]) {
				total += arr[i];
			}
		}
		for (int i = 0; i < arr.length; i++) {
			if (QualityInUse[i]) {
				arr[i] /= total;
			}
		}

		return arr;

	}

	private double[] averageQM(Matrix m) {
		double[] ret = new double[m.getRowDimension()];
		for (int i = 0; i < m.getRowDimension(); i++) {
			if (QualityInUse[i]) {
				ret[i] = 0.0;
				for (int j = 0; j < m.getColumnDimension(); j++) {
					if (QualityInUse[j]) {
						ret[i] += m.get(i, j);
					}
				}
			}
		}
		return ret;
	}

	private double[] average(Matrix m) {
		double[] ret = new double[m.getRowDimension()];
		for (int i = 0; i < m.getRowDimension(); i++) {
			ret[i] = 0.0;
			for (int j = 0; j < m.getColumnDimension(); j++) {
				ret[i] += m.get(i, j);
			}
		}
		return ret;
	}

	private void updateAhpResults() {

		/*
		 * Row data calculation
		 */
		double[] criteria = averageQM(normalizeQM(qualityMatrix));

		double[][] criteriaArrays = new double[AHPWizard.QualityNames.length][];
		for (int i = 0; i < AHPWizard.QualityNames.length; i++) {
			criteriaArrays[i] = average(normalize(valueMatrix[i]));
		}

		double resultsum = 0;
		for (int i = 0; i < numRes; i++) {
			results[i] = 0;
			for (int j = 0; j < AHPWizard.QualityNames.length; j++) {
				results[i] += criteriaArrays[j][i] * criteria[j]
						* (QualityInUse[j] ? 1 : 0);
			}
			resultsum += results[i];
		}

		/*
		 * Human readable data production
		 */

		// Criteria weights
		double[] normalizedCriteria = criteria;
		if (NORMALIZE)
			normalizedCriteria = normalizeAndFilter(criteria);

		// Add weight to table column headers
		int counter = 0;
		if (QualityInUse[Qualities.UTILIZATION.ordinal()])
			dataTableColumns[counter++].setText(String.format(
					"Utilization (%.4f)",
					normalizedCriteria[Qualities.UTILIZATION.ordinal()]));

		if (QualityInUse[Qualities.COST.ordinal()])
			dataTableColumns[counter++].setText(String.format("Cost (%.4f)",
					normalizedCriteria[Qualities.COST.ordinal()]));

		if (QualityInUse[Qualities.RELIABILITY.ordinal()])
			dataTableColumns[counter++].setText(String.format(
					"Reliability (%.4f)",
					normalizedCriteria[Qualities.RELIABILITY.ordinal()]));

		if (QualityInUse[Qualities.RESPONSETIME.ordinal()])
			dataTableColumns[counter++].setText(String.format(
					"Response Time (%.4f)",
					normalizedCriteria[Qualities.RESPONSETIME.ordinal()]));

		if (QualityInUse[Qualities.HDDUTILIZATION.ordinal()])
			dataTableColumns[counter++].setText(String.format(
					"HDD Utilization (%.4f)",
					normalizedCriteria[Qualities.HDDUTILIZATION.ordinal()]));

		if (QualityInUse[Qualities.THROUGHPUT.ordinal()])
			dataTableColumns[counter++].setText(String.format(
					"Throughput (%.4f)",
					normalizedCriteria[Qualities.THROUGHPUT.ordinal()]));

		stringCriteria = new Vector<String>();

		if (QualityInUse[Qualities.UTILIZATION.ordinal()])
			stringCriteria.add(String.format("Utilization (%.4f)",
					normalizedCriteria[Qualities.UTILIZATION.ordinal()]));

		if (QualityInUse[Qualities.COST.ordinal()])
			stringCriteria.add(String.format("Cost (%.4f)",
					normalizedCriteria[Qualities.COST.ordinal()]));

		if (QualityInUse[Qualities.RELIABILITY.ordinal()])
			stringCriteria.add(String.format("Reliability (%.4f)",
					normalizedCriteria[Qualities.RELIABILITY.ordinal()]));

		if (QualityInUse[Qualities.RESPONSETIME.ordinal()])
			stringCriteria.add(String.format("Response Time (%.4f)",
					normalizedCriteria[Qualities.RESPONSETIME.ordinal()]));

		if (QualityInUse[Qualities.HDDUTILIZATION.ordinal()])
			stringCriteria.add(String.format("HDD Utilization (%.4f)",
					normalizedCriteria[Qualities.HDDUTILIZATION.ordinal()]));

		if (QualityInUse[Qualities.THROUGHPUT.ordinal()])
			stringCriteria.add(String.format("Thrughput (%.4f)",
					normalizedCriteria[Qualities.THROUGHPUT.ordinal()]));

		// Results

		if (NORMALIZE)
			results = normalize(results);

		dataset.clear();
		resultBreakDownTable.removeAll();
		stringResults = new Vector<Vector<String>>();

		for (int i = 0; i < numRes; i++) {
			double[] row = new double[AHPWizard.QualityNames.length];
			for (int j = 0; j < AHPWizard.QualityNames.length; j++) {
				row[j] = criteriaArrays[j][i] * criteria[j];
			}

			if (NORMALIZE) {
				row = normalizeAndFilter(row);
				for (int j = 0; j < row.length; j++) {
					row[j] *= results[i];
				}
			}

			if (QualityInUse[Qualities.UTILIZATION.ordinal()])
				dataset.addValue(row[Qualities.UTILIZATION.ordinal()],
						"Utilization", evaluations.get(i).getName());
			if (QualityInUse[Qualities.COST.ordinal()])
				dataset.addValue(row[Qualities.COST.ordinal()], "Cost",
						evaluations.get(i).getName());
			if (QualityInUse[Qualities.RELIABILITY.ordinal()])
				dataset.addValue(row[Qualities.RELIABILITY.ordinal()],
						"Reliability", evaluations.get(i).getName());
			if (QualityInUse[Qualities.RESPONSETIME.ordinal()])
				dataset.addValue(row[Qualities.RESPONSETIME.ordinal()],
						"Response Time", evaluations.get(i).getName());
			if (QualityInUse[Qualities.HDDUTILIZATION.ordinal()])
				dataset.addValue(row[Qualities.HDDUTILIZATION.ordinal()],
						"HDD Utilization", evaluations.get(i).getName());
			if (QualityInUse[Qualities.THROUGHPUT.ordinal()])
				dataset.addValue(row[Qualities.THROUGHPUT.ordinal()],
						"Throughput", evaluations.get(i).getName());

			TableItem nameTI = new TableItem(resultBreakDownTable, SWT.NONE);
			String[] nameTableItems = new String[currentNumberOfQualities + 2];
			nameTableItems[0] = evaluations.get(i).getName();
			nameTableItems[1] = String.format("%.4f", results[i]);
			int cellNumber = 2;
			for (int m = 0; m < AHPWizard.QualityNames.length; m++) {
				if (QualityInUse[m]) {
					nameTableItems[cellNumber++] = String
							.format("%.4f", row[m]);
				}
			}
			nameTI.setText(nameTableItems);
			stringResults
					.add(new Vector<String>(Arrays.asList(nameTableItems)));

		}

	}

	public Table getResultBreakDownTable() {
		return resultBreakDownTable;
	}

	public TableColumn getAlternativeTableColumn() {
		return alternativeTableColumn;
	}
}
