package eu.qimpress.ide.tradeoff.ahp;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

import Jama.Matrix;

public class QualitySelectionPage extends WizardPage {
	private static int numberOfQualities = AHPWizard.QualityNames.length;
	public static final String PAGE_NAME = "Select trade-off qualities";
	private boolean[] QualityInUse;
	QualityRatingPage qrPage;
	ValueRatingPage vrPage;
	ResultsPage resPage;

	public QualitySelectionPage(QualityRatingPage _qrPage, ValueRatingPage _vrPage, ResultsPage _resPage, boolean[] qualityInUse) {
		super(PAGE_NAME, "Select trade-off qualities", null);
		setDescription("Please select which qualities you would like to use in trade-off.");
		QualityInUse = qualityInUse;
		qrPage = _qrPage;
		vrPage = _vrPage;
		resPage = _resPage;
	}

	public void createControl(Composite parent) {
		ScrolledComposite sc = new ScrolledComposite(parent, SWT.H_SCROLL
				| SWT.V_SCROLL);
		Composite topLevel = new Composite(sc, SWT.NONE);
		sc.setContent(topLevel);
		topLevel.setLayout(new RowLayout(SWT.VERTICAL));
		for (int i=0;i<AHPWizard.QualityNames.length;i++)
		{
			Button checkBox = new Button(topLevel, SWT.CHECK);
			checkBox.setText(AHPWizard.QualityNames[i]);
			checkBox.setSelection(QualityInUse[i]);
			checkBox.addSelectionListener(new CheckListener(i));
		}
		Label warning = new Label(topLevel, SWT.NONE);
		warning.setText("Warning: After changing selection of qualities, please verify all other choices that were previously entered");
		topLevel.pack(true);
		setControl(sc);
		setPageComplete(true);
	}

	class CheckListener implements SelectionListener {
		int qualityNumber;

		public CheckListener(int ordinal) {
			super();
			qualityNumber = ordinal;
		}

		@Override
		public void widgetDefaultSelected(SelectionEvent e) {
			widgetSelected(e);

		}

		@Override
		public void widgetSelected(SelectionEvent e) {
			QualityInUse[qualityNumber] =((Button)e.getSource()).getSelection();
			qrPage.drawControl(QualityInUse);
			vrPage.drawControl(QualityInUse);
			resPage.drawControl(QualityInUse);
		}

	}
}