package eu.qimpress.ide.tradeoff.ahp;

import java.io.Serializable;

import Jama.Matrix;

public class AHPDataPoint implements Serializable {
	private static final long serialVersionUID = -1666101797987380367L;
	private static final int numberOfQualities = AHPWizard.QualityNames.length;
	Matrix[] valueMatrix;
	Matrix qualityMatrix;
	int[] qualitySettings;
	int[][] valueSettings;
	boolean[] QualityInUse;



	public AHPDataPoint(int numberOfResults) {
		QualityInUse = new boolean[numberOfQualities];
		for (int i = 0; i < numberOfQualities; i++) {
			QualityInUse[i] = true;
		}
		qualityMatrix = Matrix.identity(numberOfQualities, numberOfQualities);
		for (int i = 0; i < numberOfQualities; i++)
			for (int j = 0; j < numberOfQualities; j++)
				qualityMatrix.set(i, j, 1.0);
		valueMatrix = new Matrix[numberOfQualities];
		valueMatrix[0] = Matrix.identity(numberOfResults, numberOfResults);
		for (int i = 0; i < numberOfResults; i++)
			for (int j = 0; j < numberOfResults; j++)
				valueMatrix[0].set(i, j, 1.0);
		for (int i=1;i<numberOfQualities;i++)
		{
			valueMatrix[i] = valueMatrix[0].copy();	
		}
		

		qualitySettings = new int[numberOfQualities * numberOfQualities];
		// Initialize the array to all 4 (Equal importance)
		// Size of the array is much larger than required because of the lack of
		// practical coding scheme
		
		for (int i = 0; i < numberOfQualities * numberOfQualities; i++) {
			qualitySettings[i] = 4;
		}

		valueSettings = new int[numberOfQualities][numberOfResults
				* numberOfResults];
		for (int i = 0; i < numberOfResults * numberOfResults; i++) {
			for (int j = 0; j < numberOfQualities; j++) {
				valueSettings[j][i] = 4;
			}
		}

	}

	public Matrix[] getValueMatrix() {
		return valueMatrix;
	}

	public void setValueMatrix(Matrix[] valueMatrix) {
		this.valueMatrix = valueMatrix;
	}

	public Matrix getQualityMatrix() {
		return qualityMatrix;
	}

	public void setQualityMatrix(Matrix qualityMatrix) {
		this.qualityMatrix = qualityMatrix;
	}

	public void setQualitySettings(int[] qualitySettings) {
		this.qualitySettings = qualitySettings;
	}

	public int[] getQualitySettings() {
		return qualitySettings;
	}

	public void setValueSettings(int[][] valueSettings) {
		this.valueSettings = valueSettings;
	}

	public int[][] getValueSettings() {
		return valueSettings;
	}
	
	public boolean[] getQualityInUse() {
		return QualityInUse;
	}

	public void setQualityInUse(boolean[] qualityInUse) {
		QualityInUse = qualityInUse;
	}
}
