package eu.qimpress.ide.tradeoff.ahp;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

import Jama.Matrix;

public class QualityRatingPage extends WizardPage {
	private static int numberOfQualities = AHPWizard.QualityNames.length;
	public static final String PAGE_NAME = "Determine relative criteria priority";

	private static double[] translate = { 1.0 / 9.0, 1.0 / 7.0, 1.0 / 5.0,
			1.0 / 3.0, 1.0, 3.0, 5.0, 7.0, 9.0 };
	private Matrix qualityMatrix;
	private int[] settings;
	private boolean[] QualityInUse;
	private ScrolledComposite sc;

	public QualityRatingPage(Matrix m, int[] is, boolean[] qualityInUse) {
		super(PAGE_NAME, "Determine relative criteria priority", null);
		setDescription("Please rate pairwise the quality criterias according to their relative level of importance.");
		qualityMatrix = m;
		settings = is;
		QualityInUse = qualityInUse;
	}

	private Composite globalParent;

	public void createControl(Composite parent) {
		globalParent = parent;
		drawControl(QualityInUse);
	}

	public void drawControl(boolean[] qualityInUse2) {
		Composite parent = globalParent;
		QualityInUse = qualityInUse2;

		if (sc != null)
			sc.dispose();
		sc = new ScrolledComposite(parent, SWT.H_SCROLL | SWT.V_SCROLL);
		Composite topLevel = new Composite(sc, SWT.NONE);
		sc.setContent(topLevel);
		topLevel.setLayout(new GridLayout(3, false));

		GridData radioWidth = new GridData();
		radioWidth.widthHint = 30;
		radioWidth.horizontalAlignment = GridData.CENTER;
		radioWidth.verticalAlignment = GridData.CENTER;

		Label q1 = new Label(topLevel, SWT.LEFT);
		q1.setText("Quality");
		q1.setLayoutData(new GridData(SWT.RIGHT));

		Composite titlesComposite = new Composite(topLevel, SWT.NONE);
		titlesComposite.setLayout(new GridLayout(9, false));

		String[] titles = { "EX", "VS", "ST", "MO", "EQ", "MO", "ST", "VS",
				"EX" };

		for (int i = 0; i < 9; i++) {
			Label l = new Label(titlesComposite, SWT.CENTER);
			l.setText(titles[i]);
			l.setLayoutData(radioWidth);
		}

		titlesComposite.pack();
		Label q2 = new Label(topLevel, SWT.LEFT);
		q2.setText("Quality");
		q2.setLayoutData(new GridData(SWT.BEGINNING));

		String qualities[] = AHPWizard.QualityNames;
		for (int I = 0; I < numberOfQualities; I++) {
			if (QualityInUse[I] == false)
				continue;
			for (int J = I + 1; J < numberOfQualities; J++) {
				if (QualityInUse[J] == false)
					continue;
				Label a = new Label(topLevel, SWT.LEFT);
				a.setText(qualities[I]);
				a.setLayoutData(new GridData(SWT.END, SWT.CENTER, false, false));

				Composite radioGroup = new Composite(topLevel, SWT.NONE);
				radioGroup.setLayout(new GridLayout(9, false));
				for (int i = 0; i < 9; i++) {
					Button b = new Button(radioGroup, SWT.RADIO);
					b.setLayoutData(radioWidth);
					b.addSelectionListener(new RadioListener(qualityMatrix, I,
							J, i));
					b.setSelection(i == settings[I * numberOfQualities + J]);
				}
				radioGroup.pack();

				Label b = new Label(topLevel, SWT.LEFT);
				b.setText(qualities[J]);
				b.setLayoutData(new GridData(SWT.BEGINNING, SWT.CENTER, false, false));
			}
		}

		Label description = new Label(topLevel, SWT.NONE);
		description
				.setText("Legend of quality ratings:\nEX Extreme\nVS Very Strong\nST Strong\nMO Moderate\nEQ Equal");
		GridData descgrid = new GridData();
		descgrid.verticalSpan = 3;
		description.setLayoutData(descgrid);
		description.pack(true);

		topLevel.pack(true);
		parent.layout(true, true);
		parent.redraw();
		setControl(sc);
		setPageComplete(true);
	}

	class RadioListener implements SelectionListener {

		private int quality1, quality2, value;
		private Matrix qualityMatrix;

		public RadioListener(Matrix m, int quality1, int quality2, int value) {
			super();
			this.quality1 = quality1;
			this.quality2 = quality2;
			this.value = value;
			qualityMatrix = m;
		}

		@Override
		public void widgetDefaultSelected(SelectionEvent e) {
			widgetSelected(e);

		}

		@Override
		public void widgetSelected(SelectionEvent e) {
			qualityMatrix.set(quality2, quality1, translate[value]);
			qualityMatrix.set(quality1, quality2, 1 / translate[value]);
			settings[quality1 * numberOfQualities + quality2] = value;
		}

	}
}