package eu.qimpress.ide.tradeoff.ahp;

import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Vector;

import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.app.VelocityEngine;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.MessageBox;
import org.jfree.chart.encoders.KeypointPNGEncoderAdapter;

import eu.qimpress.resultmodel.AlternativeEvaluation;

public class AHPWizard extends Wizard {

	private ArrayList<AlternativeEvaluation> evaluations;
	private QualitySelectionPage qsPage;
	private QualityRatingPage qrPage;
	private ValueRatingPage vrPage;
	private ResultsPage resPage;
	private LinkedHashMap<String, AHPDataPoint> ahpData;
	private AHPDataPoint ahpDataPoint;
	private final String ahpDataFileName = "AHPData.bin";

	public static enum Qualities {
		UTILIZATION, COST, RELIABILITY, RESPONSETIME, HDDUTILIZATION, THROUGHPUT
	};

	public static String QualityNames[] = { "Utilization", "Cost",
			"Reliability", "Response Time", "HDD Utilization", "Throughput" };

	@SuppressWarnings("unchecked")
	public AHPWizard(ArrayList<AlternativeEvaluation> selectedEvaluations) {
		super();

		try {
			Collections.sort(selectedEvaluations,
					new AlternativeEvaluationComparator());
		} catch (Exception e) {
			// Nothing interesting to do here...
		}
		evaluations = selectedEvaluations;
		// TODO load the AHPdata from a file, if not available, create a new
		// one.

		try {
			URIConverter uriConverter = URIConverter.INSTANCE;
			URI uriAHP = getAHPDataLocation(selectedEvaluations.get(0));
			System.out.println("Reading data from :" + uriAHP);

			if (uriConverter.exists(uriAHP, null)) {
				System.out.println("File exists ...");
				InputStream is = uriConverter.createInputStream(uriAHP);
				ObjectInputStream in = new ObjectInputStream(is);
				ahpData = (LinkedHashMap<String, AHPDataPoint>) in.readObject();
				System.out.println("Read " + ahpData.size() + " elements");
				in.close();

			} else {
				System.out.println("Using empty ahpData structure...");
				ahpData = new LinkedHashMap<String, AHPDataPoint>();
			}

		} catch (IOException ex) {
			ex.printStackTrace();
		} catch (ClassNotFoundException ex) {
			ex.printStackTrace();
		} finally {
			if (ahpData == null) {
				// Make sure we have a data structure to work on.
				System.out.println("Using new empty ahpData structure...");
				ahpData = new LinkedHashMap<String, AHPDataPoint>();
			}
		}
	}

	private class AlternativeEvaluationComparator implements
			Comparator<AlternativeEvaluation> {

		@Override
		public int compare(AlternativeEvaluation arg0,
				AlternativeEvaluation arg1) {
			return arg0.getId().compareTo(arg1.getId());
		}

	}

	@SuppressWarnings("deprecation")
	@Override
	public boolean performFinish() {
		// persist AHPData hashmap to a file.
		try {
			URIConverter uriConverter = URIConverter.INSTANCE;
			URI AHPDataURI = getAHPDataLocation(evaluations.get(0));
			/*
			 * I am not sure if below code is needed. It seems to work without
			 * it. if (uriConverter.exists(AHPDataURI, null)) {
			 * uriConverter.delete(AHPDataURI, null); }
			 */
			OutputStream os = uriConverter.createOutputStream(AHPDataURI);
			ObjectOutputStream out = new ObjectOutputStream(os);
			out.writeObject(ahpData);
			out.close();
		} catch (IOException ex) {
			ex.printStackTrace();
		}

		String fileName = resPage.txtfilename.getText();
		if (fileName == null || fileName.length() == 0) {
			MessageBox messageBox = new MessageBox(getShell(),
					SWT.ICON_QUESTION | SWT.YES | SWT.NO);
			messageBox
					.setMessage("Filename is empty. Are you sure that you want to quit without saving results?");
			messageBox.setText("Exiting Application");
			int response = messageBox.open();
			if (response == SWT.YES)
				return true;
			else
				return false;
		}

		String imageFileName = fileName.substring(0, fileName
				.lastIndexOf(".html"))
				+ ".png";

		try {
			/*
			 * Saving HTML data to fileName
			 */
			Velocity.init();
			VelocityContext context = new VelocityContext();

			context.put("imageFilename", imageFileName.substring(imageFileName
					.lastIndexOf('\\') + 1));

			context.put("queryComparisons", getQualityComparison());
			context.put("valueComparisons", getValueComparisons());
			context.put("normalized", resPage.NORMALIZE);
			context.put("criteria", resPage.stringCriteria);
			context.put("results", resPage.stringResults);
			System.out.println(context.toString());
			FileWriter fw = new FileWriter(fileName);
			VelocityEngine engine = new VelocityEngine();
			engine.evaluate(context, fw, "", this.getClass()
					.getResourceAsStream("/exporttemplate.vm"));

			fw.close();

		} catch (Exception e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}

		try {

			/*
			 * Saving image to imageFileName
			 */
			KeypointPNGEncoderAdapter encoder = new KeypointPNGEncoderAdapter();
			encoder.setEncodingAlpha(true);
			byte[] imageData = encoder
					.encode(resPage.chart.createBufferedImage(600, 400,
							BufferedImage.BITMASK, null));
			FileOutputStream fos = new FileOutputStream(imageFileName);
			fos.write(imageData);
			fos.close();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return true;
	}

	private Vector<AHPComparison> getQualityComparison() {
		Vector<AHPComparison> comparisons = new Vector<AHPComparison>();
		String qualities[] = QualityNames;
		for (int i = 0; i < qualities.length; i++) {
			for (int j = i + 1; j < qualities.length; j++) {
				if (ahpDataPoint.QualityInUse[i]
						&& ahpDataPoint.QualityInUse[j]) {
					comparisons.add(new AHPComparison(qualities[i],
							qualities[j], ahpDataPoint.qualitySettings[i
									* qualities.length + j]));
				}
			}
		}
		return comparisons;
	}

	private Vector<AHPComparison> getValueComparisons() {
		Vector<AHPComparison> comparisons = new Vector<AHPComparison>();
		for (Qualities q : Qualities.values()) {
			if (ahpDataPoint.QualityInUse[q.ordinal()]) {
				for (int i = 0; i < evaluations.size(); i++) {
					for (int j = i + 1; j < evaluations.size(); j++) {

						comparisons.add(new AHPComparison(evaluations.get(i)
								.getName()
								+ ValueRatingPage.getValueForQuality(
										evaluations.get(i), q), evaluations
								.get(j).getName()
								+ ValueRatingPage.getValueForQuality(
										evaluations.get(j), q),
								ahpDataPoint.valueSettings[q.ordinal()][i
										* evaluations.size() + j]));
					}
				}
			}
		}
		return comparisons;
	}

	public class AHPComparison {
		private String Left;
		private String Right;
		private String[] RadioList;

		public AHPComparison(String left, String right, int value) {
			Left = left;
			Right = right;
			RadioList = new String[9];
			for (int i = 0; i < 9; i++) {
				if (value == i)
					RadioList[i] = "X";
				else
					RadioList[i] = "";
			}
		}

		public void setLeft(String left) {
			Left = left;
		}

		public String getLeft() {
			return Left;
		}

		public void setRight(String right) {
			Right = right;
		}

		public String getRight() {
			return Right;
		}

		public void setRadioList(String[] radioList) {
			RadioList = radioList;
		}

		public String[] getRadioList() {
			return RadioList;
		}
	}

	public void addPages() {
		ahpDataPoint = new AHPDataPoint(evaluations.size());
		System.out.println(ahpDataPoint.toString());
		// Build up as hashKey that uniquely defines the set of
		// AlternativeEvaluations
		// we are performing an AHP evaluation on.

		String hashKey = "";
		for (AlternativeEvaluation alternativeEval : evaluations) {
			hashKey += alternativeEval.getId();
		}

		System.out.println("Builded hash key: " + hashKey);

		// Check if we have previously visited this combination of
		// AlternativeEvaluations,
		// if so, take over the complete AHPDataPoint, otherwise, just copy the
		// quality matrix of the last entry (if available).

		if (ahpData.containsKey(hashKey)) {
			// We have data of this earlier combination of alternative
			// evaluations
			// replace data with this earlier stuff
			ahpDataPoint = ahpData.get(hashKey);
		} else {
			// // New stuff, see if we can reuse the quality matrix
			// if (!ahpData.isEmpty()) {
			// for (AHPDataPoint datapoint : ahpData.values()) {
			// if (datapoint.getQualitySettings() != null) {
			// ahpDataPoint.setQualitySettings(datapoint
			// .getQualitySettings());
			// }
			// }
			// } else {
			// // Skip, there is no prior information to use, use the default.
			// }
		}
		qrPage = new QualityRatingPage(ahpDataPoint.getQualityMatrix(),
				ahpDataPoint.getQualitySettings(), ahpDataPoint
						.getQualityInUse());
		vrPage = new ValueRatingPage(ahpDataPoint.getValueMatrix(),
				evaluations, ahpDataPoint.getValueSettings(), ahpDataPoint
						.getQualityInUse());
		resPage = new ResultsPage(ahpDataPoint, evaluations, ahpDataPoint
				.getQualityInUse());
		qsPage = new QualitySelectionPage(qrPage, vrPage, resPage, ahpDataPoint
				.getQualityInUse());
		ahpData.put(hashKey, ahpDataPoint); // Store the data in the hash map
		addPage(qsPage);
		addPage(qrPage);
		addPage(vrPage);
		addPage(resPage);

	}

	/**
	 * Method to get the location of the file where the AHP data is located. A
	 * relative path to the storage location of an AlternativeEvaluation in the
	 * workspace is used for this purpose, as this points to the right project
	 * location
	 * 
	 * @param ae
	 *            The AlternativeEvaluation
	 * @return A platform uri that can be used to access the AHP data
	 */
	private URI getAHPDataLocation(AlternativeEvaluation ae) {
		URI uri = ae.eResource().getURI();
		System.out.println("uri of evaluation:" + uri);
		String platformLocation = uri.toString().substring(0,
				uri.toString().lastIndexOf(Path.SEPARATOR));
		platformLocation += Path.SEPARATOR + ".." + Path.SEPARATOR
				+ ahpDataFileName;
		System.out.println("Platform uri: " + platformLocation);
		return URI.createURI(platformLocation);
	}

}
