/*
* generated by Xtext
*/
package org.somox.metrics.contentassist;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.ui.core.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.core.editor.contentassist.ICompletionProposalAcceptor;
import org.somox.metrics.contentassist.AbstractDSLProposalProvider;
/**
 * see http://www.eclipse.org/Xtext/documentation/latest/xtext.html#contentAssist on how to customize content assistant
 */
public class DSLProposalProvider extends AbstractDSLProposalProvider {

	private static final List<String> registeredBasicMetrics = getRegisteredMetricIDs();
	private static final String ORG_SOMOX_CORE_METRIC_EXTENSION_ID = "org.somox.core.metric";
	
	/* (non-Javadoc)
	 * @see org.somox.metrics.contentassist.AbstractDSLProposalProvider#completeExternalMetric_Name(org.eclipse.emf.ecore.EObject, org.eclipse.xtext.Assignment, org.eclipse.xtext.ui.core.editor.contentassist.ContentAssistContext, org.eclipse.xtext.ui.core.editor.contentassist.ICompletionProposalAcceptor)
	 */
	@Override
	public void completeExternalMetric_Name(EObject model,
			Assignment assignment, ContentAssistContext context,
			ICompletionProposalAcceptor acceptor) {
		super.completeExternalMetric_Name(model, assignment, context, acceptor);
		getRegisteredMetrics(context, acceptor);
	}

	private void getRegisteredMetrics(ContentAssistContext context,
			ICompletionProposalAcceptor acceptor) {
		// super.completeStepwiseMetric_InnerMetric(model, assignment, context, acceptor);
		
		for (String metricID : registeredBasicMetrics) {
			// create the completion proposal
			// the result may be null as the createCompletionProposal(..) methods 
			// check for valid prefixes
			// and terminal token conflicts
			ICompletionProposal completionProposal = 
			    createCompletionProposal(metricID, context);
		
			// register the proposal, the acceptor handles null-values gracefully
			acceptor.accept(completionProposal);
		}
	}

	private static List<String> getRegisteredMetricIDs() {
		ArrayList<String> result = new ArrayList<String>();
		IConfigurationElement[] metricExtensions = Platform
			.getExtensionRegistry().getConfigurationElementsFor(
				ORG_SOMOX_CORE_METRIC_EXTENSION_ID);
		for (IConfigurationElement metricExtension : metricExtensions) {
			if (metricExtension.getName().equals("metric")) {
				result.add(metricExtension.getAttribute("id"));
			}
		}
		return result;
	}
}
