package eu.qimpress.reverseengineering.ui.launch.configbuilder;

import java.util.Map;

import org.eclipse.core.runtime.IPath;
import org.ow2.dsrg.fm.qabstractor.integration.GAST2TBPTab;
import org.somox.ui.runconfig.configbuilder.UIBasedSomoxConfigurationBuilder;

import de.fzi.sissy.main.configurations.SISSyConfiguration;
import de.fzi.sissy.ui.configbuilder.UIBasedGASTImporterConfigurationBuilder;
import de.fzi.sissy.ui.configbuilder.UIBasedSISSyConfigurationBuilder;
import de.uka.ipd.sdq.workflow.launchconfig.configbuilder.AbstractUIBasedConfigurationBuilder;
import eu.qimpress.ide.backbone.core.model.IQApplicationModel;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.model.IQElement.ElementType;
import eu.qimpress.ide.backbone.core.ui.tabs.QImpressAlternativeSelectionTab;
import eu.qimpress.reverseengineering.ui.launch.ReverseEngineeringConfiguration;

public class UIBasedReverseEngineeringConfigurationBuilder 
extends
		AbstractUIBasedConfigurationBuilder<ReverseEngineeringConfiguration> {

	private UIBasedSISSyConfigurationBuilder sissyBuilder;
	private UIBasedGASTImporterConfigurationBuilder sissy2gastBuilder;
	private UIBasedSomoxConfigurationBuilder somoxBuilder;
	private boolean tbpEnabled;

	public UIBasedReverseEngineeringConfigurationBuilder(
			Map<String, Object> attributes) {
		super(attributes);
		
		this.sissyBuilder = new UIBasedSISSyConfigurationBuilder(attributes);
		this.somoxBuilder = new UIBasedSomoxConfigurationBuilder(attributes);
	}

	/* (non-Javadoc)
	 * @see de.uka.ipd.sdq.workflow.launchconfig.configbuilder.AbstractUIBasedConfigurationBuilder#internalBuild(de.uka.ipd.sdq.workflow.AbstractJobConfiguration, java.util.Map)
	 */
	@Override
	protected ReverseEngineeringConfiguration internalBuild(
			Map<String,Object> attributes) {

		SISSyConfiguration sissyConfiguration = sissyBuilder.build();
		
		ReverseEngineeringConfiguration myConfig = 
			new ReverseEngineeringConfiguration(
					sissyConfiguration,
					sissyConfiguration.getGASTImporterConfiguration(),
					somoxBuilder.build(),
					(String)attributes.get(GAST2TBPTab.GAST2TBP_LABEL)
					);
		
		myConfig.getSissy2GASTConfiguration().setDoExportGAST(true);

		String guid = (String) attributes.get(QImpressAlternativeSelectionTab.SELECTED_ALTERNATIVE_GUID);
		if (guid != null) {
			IQApplicationModel model = QImpressApplicationModelManager.getManager().getQAppModel();
			IQElement alternative = model.getElementByID(guid);
			IQElement current = alternative;
			while (current.getElementType() != ElementType.Q_PROJECT)
				current = current.getParent();
			IQProject targetProject = (IQProject) current;
			IPath projectPath = targetProject.getCorrespondingResource().getLocation();
			myConfig.setWorkingDirectory(projectPath.toString()+"/alternatives/"+guid);
			myConfig.getSomoxConfiguration().getSomoxConfiguration().getFileLocations().setOutputFolder("/alternatives/"+guid);
			myConfig.getSissy2GASTConfiguration().setGASTFilePath(myConfig.getWorkingDirectory() + "/gastmodel.gast");
		}
		// TODO: Use new Somox Config object as soon as it exists
		// attributes.put(SoMoXProjectPreferences.SOMOX_PROJECT_NAME, "test");
		// attributes.put(SoMoXProjectPreferences.SOMOX_ANALYZER_INPUT_FILE, "test/out.gast");
		
		return myConfig;
	}
	
}
