/**
 * 
 */
package eu.qimpress.reverseengineering.ui.launch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import org.apache.log4j.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.emf.common.util.URI;
import org.ow2.dsrg.fm.qabstractor.integration.GAST2TBPJob;
import org.somox.analyzer.simplemodelanalyzer.jobs.SimpleModelAnalyzerJob;
import org.somox.common.SoMoXProjectPreferences;

import de.fzi.sissy.gastimporter.jobs.GASTModelImporterJob;
import de.fzi.sissy.main.jobs.SISSyJob;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.OrderPreservingCompositeJob;
import de.uka.ipd.sdq.workflow.Workflow;
import de.uka.ipd.sdq.workflow.launchconfig.AbstractConfigBuilderBasedLaunchConfigurationDelegate;
import de.uka.ipd.sdq.workflow.launchconfig.LoggerAppenderStruct;
import de.uka.ipd.sdq.workflow.launchconfig.configbuilder.AbstractUIBasedConfigurationBuilder;
import eu.qimpress.ide.backbone.core.model.IQApplicationModel;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.model.IQElement.ElementType;
import eu.qimpress.ide.backbone.core.ui.tabs.QImpressAlternativeSelectionTab;
import eu.qimpress.reverseengineering.gast2seff.jobs.GAST2SEFFJob;
import eu.qimpress.reverseengineering.ui.jobs.PrintInformationJob;
import eu.qimpress.reverseengineering.ui.launch.configbuilder.UIBasedReverseEngineeringConfigurationBuilder;

/**
 * @author Snowball
 *
 */
public class ReverseEngineeringWorkflowLaunchDelegate 
extends
		AbstractConfigBuilderBasedLaunchConfigurationDelegate<ReverseEngineeringConfiguration,Workflow> 
implements
		ILaunchConfigurationDelegate {

	private static final String LOG_PATTERN = "%-5p: %m\n";
	
	/* (non-Javadoc)
	 * @see de.uka.ipd.sdq.workflow.launchconfig.AbstractWorkflowBasedLaunchConfigurationDelegate#createWorkflowJob(de.uka.ipd.sdq.workflow.launchconfig.AbstractWorkflowBasedRunConfiguration, org.eclipse.debug.core.ILaunch)
	 */
	@Override
	protected IJob createWorkflowJob(ReverseEngineeringConfiguration config,
			ILaunch launch) throws CoreException {
		int step = 0;
		
		OrderPreservingCompositeJob reverseEngineeringToolchainJob = new OrderPreservingCompositeJob();

		configureSISSyJob(config, reverseEngineeringToolchainJob, ++step);
		configureSISSy2GAST(config, reverseEngineeringToolchainJob, ++step);
		configureSoMoX(config, reverseEngineeringToolchainJob, ++step);
		configureGAST2SEFF(config, reverseEngineeringToolchainJob, ++step);
		configureGAST2TBP(config, reverseEngineeringToolchainJob, ++step);
		
		return reverseEngineeringToolchainJob;
	}

	/* (non-Javadoc)
	 * @see de.uka.ipd.sdq.workflow.launchconfig.AbstractConfigBuilderBasedLaunchConfigurationDelegate#getConfigurationBuilder(org.eclipse.debug.core.ILaunchConfiguration)
	 */
	@SuppressWarnings("unchecked")
	@Override
	protected AbstractUIBasedConfigurationBuilder<ReverseEngineeringConfiguration> getConfigurationBuilder(
			ILaunchConfiguration configuration) throws CoreException {
		Map<String,Object> attributes = new HashMap<String, Object>(configuration.getAttributes());

		// TODO: Temporary hack as long as no real somox config exists
		String somoxProjectName = getSomoxProjectName(attributes);
		String guid = (String) attributes.get(QImpressAlternativeSelectionTab.SELECTED_ALTERNATIVE_GUID);
		
		attributes.put(SoMoXProjectPreferences.SOMOX_PROJECT_NAME, somoxProjectName);
		attributes.put(SoMoXProjectPreferences.SOMOX_ANALYZER_INPUT_FILE, somoxProjectName + "/alternatives/" + guid + "/gastmodel.gast");
		
		return new UIBasedReverseEngineeringConfigurationBuilder(attributes);
	}
	
	private String getSomoxProjectName(Map<String, Object> attributes) {
		String guid = (String) attributes.get(QImpressAlternativeSelectionTab.SELECTED_ALTERNATIVE_GUID);
		if (guid != null) {
			IQApplicationModel model = QImpressApplicationModelManager.getManager().getQAppModel();
			IQElement alternative = model.getElementByID(guid);
			IQElement current = alternative;
			while (current.getElementType() != ElementType.Q_PROJECT)
				current = current.getParent();
			IQProject targetProject = (IQProject) current;
			return targetProject.getCorrespondingResource().getName();
		}
		return null;
	}

	/* (non-Javadoc)
	 * @see de.uka.ipd.sdq.workflow.launchconfig.AbstractWorkflowBasedLaunchConfigurationDelegate#setupLogging(org.apache.log4j.Level)
	 */
	@Override
	protected ArrayList<LoggerAppenderStruct> setupLogging(Level logLevel)
			throws CoreException {
		
		ArrayList<LoggerAppenderStruct> loggerList = new ArrayList<LoggerAppenderStruct>();

		loggerList.add(setupLogger("de.uka.ipd.sdq.workflow", logLevel,	LOG_PATTERN));
		loggerList.add(setupLogger("de.fzi.sissy2gast", logLevel, LOG_PATTERN));
		loggerList.add(setupLogger("de.fzi.sissy", logLevel, LOG_PATTERN));
		loggerList.add(setupLogger("eu.qimpress", logLevel, LOG_PATTERN));
		loggerList.add(setupLogger("org.somox", logLevel, LOG_PATTERN));
		loggerList.add(setupLogger("org.ow2.dsrg.fm.qabstractor.integration", logLevel, LOG_PATTERN));
		loggerList.add(setupLogger("org.ow2.dsrg.fm.qabstractor", logLevel, LOG_PATTERN));
		loggerList.add(setupLogger("org.ow2.dsrg.fm.qabstractor.extract.ClassExtractor", logLevel, LOG_PATTERN));		

		return loggerList;
	}	

	private void configureGAST2SEFF(ReverseEngineeringConfiguration config,
			OrderPreservingCompositeJob reverseEngineeringToolchainJob, int step) throws CoreException {

		reverseEngineeringToolchainJob.add(new PrintInformationJob(createStepInfo(step,"Running GAST2SEFF to create behaviours")));
		reverseEngineeringToolchainJob.add(new GAST2SEFFJob(URI.createFileURI(config.getWorkingDirectory()+"/internal_architecture_model.samm_repository")));
	}
	
	private void configureGAST2TBP(ReverseEngineeringConfiguration config,
			OrderPreservingCompositeJob reverseEngineeringToolchainJob, int step) throws CoreException {
		
		if (config.getGast2TbpConfig()) {
			reverseEngineeringToolchainJob.add(new PrintInformationJob(createStepInfo(step,"Running GAST2TBP transformation")));
			reverseEngineeringToolchainJob.add(new GAST2TBPJob(URI.createFileURI(config.getWorkingDirectory()+"/internal_architecture_model.samm_repository")));
		}
	}
	
	private void configureSoMoX(ReverseEngineeringConfiguration config,
			OrderPreservingCompositeJob reverseEngineeringToolchainJob, int step) throws CoreException {

		reverseEngineeringToolchainJob.add(new PrintInformationJob(createStepInfo(step,"Running SoMoX to extract components")));
		reverseEngineeringToolchainJob.add(new SimpleModelAnalyzerJob(config.getSomoxConfiguration()));
	}

	private void configureSISSy2GAST(ReverseEngineeringConfiguration config,
			OrderPreservingCompositeJob reverseEngineeringToolchainJob, int step) throws CoreException {
		reverseEngineeringToolchainJob.add(new PrintInformationJob(createStepInfo(step,"Running SISSy2GAST")));
		reverseEngineeringToolchainJob.add(new GASTModelImporterJob(config.getSissy2GASTConfiguration()));
	}

	private void configureSISSyJob(ReverseEngineeringConfiguration config,
			OrderPreservingCompositeJob reverseEngineeringToolchainJob, int step)
			throws CoreException {
		reverseEngineeringToolchainJob.add(new PrintInformationJob(createStepInfo(step,"Running SISSy")));
		reverseEngineeringToolchainJob.add(new SISSyJob(config.getSissyConfiguration()));
	}

	private String[] createStepInfo(int step, String msg) {
		return new String[] {
				"----------------------------------------------------",
				"Step " + step + ". " + msg,
				"----------------------------------------------------"
		};
	}
}
