/**
 * 
 */
package eu.qimpress.reverseengineering.ui.launch;

import org.somox.ui.runconfig.ModelAnalyzerConfiguration;

import de.fzi.sissy.gastimporter.GASTImporterConfiguration;
import de.fzi.sissy.main.configurations.SISSyConfiguration;
import de.uka.ipd.sdq.workflow.launchconfig.AbstractWorkflowBasedRunConfiguration;

/**
 * @author Snowball
 *
 */
public class ReverseEngineeringConfiguration extends
		AbstractWorkflowBasedRunConfiguration {
	
	private SISSyConfiguration sissyConfiguration = null;
	private GASTImporterConfiguration sissy2gastConfiguration = null;
	private ModelAnalyzerConfiguration somoxConfiguration = null;
	private String workingDirectoryPath = null;
	private String gast2tbpEnabled = null;

	/**
	 * 
	 */
	public ReverseEngineeringConfiguration(
			SISSyConfiguration sissyConfiguration,
			GASTImporterConfiguration sissy2gastConfiguration,
			ModelAnalyzerConfiguration somoxConfiguration,
			String gast2tbpConfig) {
		super();
		
		this.sissyConfiguration = sissyConfiguration;
		this.sissy2gastConfiguration = sissy2gastConfiguration;
		this.somoxConfiguration = somoxConfiguration;
		this.gast2tbpEnabled = gast2tbpConfig; 
	}
	
	public SISSyConfiguration getSissyConfiguration() {
		return sissyConfiguration;
	}

	public GASTImporterConfiguration getSissy2GASTConfiguration() {
		return sissy2gastConfiguration;
	}

	public ModelAnalyzerConfiguration getSomoxConfiguration() {
		return somoxConfiguration;
	}
	
	public boolean getGast2TbpConfig() {
 		return gast2tbpEnabled.equals("true");
	}

	@Override
	public String getErrorMessage() {
		String errorMessage = "";
		if ((getSissyConfiguration()!= null) && (getSissyConfiguration().getErrorMessage() != null))
			errorMessage += getSissyConfiguration().getErrorMessage();
		if ((getSissy2GASTConfiguration()!= null) && (getSissy2GASTConfiguration().getErrorMessage() != null))
			errorMessage += getSissy2GASTConfiguration().getErrorMessage();
		if ((getSomoxConfiguration()!= null) && (getSomoxConfiguration().getErrorMessage() != null))
			errorMessage += getSomoxConfiguration().getErrorMessage();
		return errorMessage.length() == 0 ? null : errorMessage;
	}

	@Override
	public void setDefaults() {
		this.sissyConfiguration.setDefaults();
		this.sissy2gastConfiguration.setDefaults();
		this.somoxConfiguration.setDefaults();
		this.gast2tbpEnabled = "true";
	}

	public void setWorkingDirectory(String dir) {
		this.workingDirectoryPath = dir;
	}

	public String getWorkingDirectory() {
		return this.workingDirectoryPath;
	}
}
