package eu.qimpress.reverseengineering.ui.jobs;

import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;

import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;

public class PrintInformationJob implements IJob {

	private String[] infos = null;
	private Logger logger = Logger.getLogger(PrintInformationJob.class);
	
	public PrintInformationJob(String info) {
		super();
		
		this.infos = new String[] { info };
	}
	
	public PrintInformationJob(String[] infos) {
		super();
		
		this.infos = infos;
	}
	
	@Override
	public void execute(IProgressMonitor monitor) throws JobFailedException,
			UserCanceledException {
		for (String info : infos) {
			logger.info(info);
		}
	}

	@Override
	public String getName() {
		return "Print Status Information";
	}

	@Override
	public void rollback(IProgressMonitor monitor)
			throws RollbackFailedException {
		// do nothing
	}

}
