package org.ow2.dsrg.fm.qabstractor.integration;

import java.util.HashMap;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;


public class GAST2TBPTab extends AbstractLaunchConfigurationTab {

	//private final ModifyListener modifyListener = new ModifyListener() {

		private HashMap<String, Widget> id2widgetMap;
		
		public static final String GAST2TBP_LABEL = "GAST2TBP_CheckBox";
		
		Button checkbox;
		

		// private static final String SISSY2GAST_CHECK_QUERY =
		// "sissy2gast.checkqueryyesno";;

		@Override
		public void createControl(Composite parent) {
			this.id2widgetMap = new HashMap<String, Widget>();

			final ScrolledComposite scrollContainer = new ScrolledComposite(parent,
					SWT.BORDER | SWT.V_SCROLL);
			scrollContainer.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

			Composite container = new Composite(scrollContainer, SWT.NONE);
			scrollContainer.setContent(container);
			container.setLayout(new GridLayout());
			container.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
			
			checkbox = createCheckButton(container, "Run G-AST2TBP transformation");
			checkbox.addSelectionListener(new SelectionAdapter() {
	            public void widgetSelected(SelectionEvent e) {
	                updateLaunchConfigurationDialog();
	            }
	        });	
			
			id2widgetMap.put(GAST2TBP_LABEL, checkbox);

			container.setSize(container.computeSize(SWT.DEFAULT, SWT.DEFAULT));
			scrollContainer.setExpandHorizontal(true);
			setControl(scrollContainer);
		}

		@Override
		public String getName() {
			return "G-AST2TBP Settings";
		}

		@Override
		public void initializeFrom(ILaunchConfiguration configuration) {			
			//setDefaults((ILaunchConfigurationWorkingCopy) configuration);
			for (String key : id2widgetMap.keySet()) {
				Object mappedWidget = id2widgetMap.get(key);
				if (mappedWidget instanceof Text) {
					Text text = (Text) mappedWidget;
					try {
						((Text) mappedWidget).setText(configuration.getAttribute(
								key, ""));
					} catch (CoreException e) {
						e.printStackTrace();
					}
				} else if (mappedWidget instanceof Button) {
					Button button = (Button) mappedWidget;
					try {
						if (configuration.getAttribute(key, "false").equals("true")) {
							button.setSelection(true);
						} else {
							button.setSelection(false);
						}
					} catch (CoreException e) {
						e.printStackTrace();
					}
				} else if (mappedWidget instanceof Combo) {
					Combo combo = (Combo) mappedWidget;
					try {
						combo.setText(configuration.getAttribute(key, "NONE"));
					} catch (CoreException e) {
						e.printStackTrace();
					}
				}
			}
			
		}

		@Override
		public void performApply(ILaunchConfigurationWorkingCopy configuration) {
			for (String key : id2widgetMap.keySet()) {
				Object mappedWidget = id2widgetMap.get(key);
				if (mappedWidget instanceof Text) {
					Text text = (Text) mappedWidget;
					configuration.setAttribute(key, text.getText());
				} else if (mappedWidget instanceof Button) {
					Button button = (Button) mappedWidget;
					if (button.getSelection()) {
						configuration.setAttribute(key, "true");
					} else {
						configuration.setAttribute(key, "false");
					}
				} else if (mappedWidget instanceof Combo) {
					Combo combo = (Combo) mappedWidget;
					configuration.setAttribute(key, combo.getText());
				}
			}
		}

		@Override
		public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
			configuration.setAttribute(GAST2TBP_LABEL, new String("true"));
		}		
}