package org.ow2.dsrg.fm.qabstractor.integration;

import java.io.IOException;
import java.util.HashMap;

import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.ow2.dsrg.fm.qabstractor.Transformer;
import org.ow2.dsrg.fm.qabstractor.extract.GastServiceExtractorLoader;
import org.ow2.dsrg.fm.qabstractor.extract.MetadataExtractor;

import de.fzi.gast.core.Root;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import eu.qimpress.sourcecodedecorator.SourceCodeDecoratorRepository;

public class GAST2TBPJob implements IJob {
	private Logger logger = Logger.getLogger(GAST2TBPJob.class);
	
	private URI sammInstanceURI;
	private URI gastBehaviourURI;
	private URI sourcecodeDecoratorURI;
	private URI gastURI;
	
	private static final String GAST_STUB_BEHAVIOUR_EXTENSION = "samm_gastbehaviour";
	private static final String SOURCECODE_DECORATOR_EXTENSION = "sourcecodedecorator";
	private static final String TBP_FOLDER = "Tbp";
	private static final String GAST_FILE = "gastmodel.gast";
	
	private Resource gastConnection;
	private Resource sammInstance;
	private Resource sourceCodeDecoratorInstance;
	private Resource gast;
	private String outputPath;
	
	/**
	 * The resource set used to load and store all reources needed for the transformation
	 */
	private ResourceSet resourceSet = new ResourceSetImpl();	

	public GAST2TBPJob(
			URI sammInstanceURI) {
		this (sammInstanceURI,
				sammInstanceURI.trimFileExtension().appendFileExtension(GAST_STUB_BEHAVIOUR_EXTENSION),
				sammInstanceURI.trimFileExtension().appendFileExtension(SOURCECODE_DECORATOR_EXTENSION),
				sammInstanceURI.trimSegments(1).appendSegment(GAST_FILE)
				);
	}
	
	public GAST2TBPJob(
			URI sammInstanceURI,
			URI gastBehaviourRepositoryURI,
			URI sourcecodeDecoratorURI,
			URI gastURI) {
		super();
		
		this.sammInstanceURI = sammInstanceURI;
		this.gastBehaviourURI = gastBehaviourRepositoryURI;
		this.sourcecodeDecoratorURI = sourcecodeDecoratorURI;
		this.gastURI = gastURI;
		this.outputPath = gastURI.trimSegments(1).toFileString();
		
	}	
	
	@Override
	public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
		logger.debug("GAST2TBP started...");
		
		sammInstance = loadResource(sammInstanceURI);
		gastConnection = loadResource(gastBehaviourURI);
		gast = loadResource(gastURI);
		
		sourceCodeDecoratorInstance = loadResource(sourcecodeDecoratorURI);
		
		SourceCodeDecoratorRepository scdrep = (SourceCodeDecoratorRepository) sourceCodeDecoratorInstance.getContents().get(0);
		
		

		if (scdrep == null) {
			logger.warn("Failed to load sourcecode decorator repository, exiting.");
			return;
		}
		
		/*
		
		EList<FileLevelSourceCodeLink> links = scdrep.getFileLevelSourceCodeLink();
		EList<MethodLevelSourceCodeLink> links2 = scdrep.getMethodLevelSourceCodeLink();
		EList<ComponentImplementingClassesLink> links3 = scdrep.getComponentImplementingClassesLink();
		
		
		for (FileLevelSourceCodeLink l : links) {
			logger.info("Link: " + l.getComponentType().toString() + l.getFile().toString());
		}		
		*/
		
		// get the root node of the GAST model
		Root r = (Root) gast.getContents().get(0);
		
		if (r == null) {
			logger.warn("Failed to load gast model, exiting.");
			return;
		}
		
		GastServiceExtractorLoader gse = new GastServiceExtractorLoader(scdrep);
		
		MetadataExtractor mde = gse.load(); 
		try {
			Transformer.transform(outputPath, r, mde, scdrep);			
		}
		
		catch (IOException e) {
            logger.warn(e.getMessage());
            return;
		}

		logger.debug("GAST2TBP finished.");
		
	}

	@Override
	public String getName() {
		return "GAST2TBP Transformation Job";
	}

	@Override
	public void rollback(IProgressMonitor monitor)
			throws RollbackFailedException {
		// not needed
		
	}
	

	/**
	 * Load an existing resource in this class' resource set
	 * @param uri
	 * @return
	 * @throws JobFailedException
	 */
	private Resource loadResource(URI uri) throws JobFailedException {
		Resource resource = this.resourceSet.getResource(uri, true);

		/*
		Map<Object, Object> loadOptions = ((XMLResourceImpl)resource).getDefaultLoadOptions();
		loadOptions.put(XMLResource.OPTION_DEFER_ATTACHMENT, Boolean.TRUE);
		loadOptions.put(XMLResource.OPTION_DEFER_IDREF_RESOLUTION, Boolean.TRUE);
		loadOptions.put(XMLResource.OPTION_USE_DEPRECATED_METHODS, Boolean.FALSE);
		loadOptions.put(XMLResource.OPTION_USE_PARSER_POOL, new XMLParserPoolImpl());
		loadOptions.put(XMLResource.OPTION_USE_XML_NAME_TO_FEATURE_MAP, new HashMap<Object,Object>());
		// ((ResourceImpl)resource).setIntrinsicIDToEObjectMap(new HashMap());
		
		
		try {
			resource.load(null);
		} catch (IOException e) {
			throw new JobFailedException("Loading of a required resource failed",e);
		}
		*/
		return resource;
	}	

	/**
	 * Create a new resource
	 * @param uri
	 * @return
	 */
	private Resource createResource(URI uri) {
		Resource resource = this.resourceSet.createResource(uri);
		return resource;
	}
	
	/**
	 * Save the given resource
	 * @param resource
	 * @throws JobFailedException
	 */
	private void saveResource(Resource resource) throws JobFailedException {
		try {
			resource.save(new HashMap());
		} catch (IOException e) {
			throw new JobFailedException("Saving model output failed",e);
		}
	}	
	
}
