
package org.ow2.dsrg.fm.qabstractor.utils;

import de.fzi.gast.functions.Method;

/**
 * Utility class for manipulating with GAST Methods.
 * @author Josef Reidinger
 */
public class MethodUtils {
    /**
     * Gets fully qualified name of method
     * @param method which name is required
     * @return fully qualified name in format classQualifiedName.methodName
     */
    public static String getFullyQualfiedName(Method method){
        String sn = method.getSimpleName();
        String cn = method.getSurroundingClass().getQualifiedName();
        return cn+"."+sn;
    }

    private MethodUtils() {
    }
}
