
package org.ow2.dsrg.fm.qabstractor.utils;

import de.fzi.gast.functions.Method;
import java.util.Comparator;

/**
 * Comparator for methods. Compare is based on surrounding class, then method
 * names and then if its argument matching.
 * Used in sets.
 * @author Josef Reidinger
 */
public class MethodComparator implements Comparator<Method>{

    @Override
    public int compare(Method o1, Method o2) {
        //compare class names
        int ret = o1.getSurroundingClass().getQualifiedName().compareTo(
                o2.getSurroundingClass().getQualifiedName());
        //compare method names if class is same
        if (ret==0){
            ret = o1.getSimpleName().compareTo(o2.getSimpleName());
            //compare method arguments
            //TODO exact compare
            if (ret==0){
                if (o1.getFormalParameters() == null || o2.getFormalParameters() == null)
                {
                    ret = 0;
                } else {
                ret = o1.getFormalParameters().size()-o2.getFormalParameters().size();
                }
            }
        }
        return ret;
    }


}
