package org.ow2.dsrg.fm.qabstractor.utils;

import de.fzi.gast.accesses.FunctionAccess;
import de.fzi.gast.accesses.VariableAccess;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil.Copier;

/**
 * Extended EMF Copier. Some accessed doesn't copy its target, so it is
 * manually copied.
 * Used also to create expression copy.
 * @author Josef Reidinger
 */
public class GastCopier extends Copier {

    @Override
    protected void copyContainment(EReference eReference, EObject eObject, EObject copyEObject) {
        super.copyContainment(eReference, eObject, copyEObject);
        if (eObject instanceof FunctionAccess) {
            ((FunctionAccess) copyEObject).setAccessedTarget(((FunctionAccess) eObject).getTargetFunction());
        }
        if (eObject instanceof VariableAccess) {
            ((VariableAccess) copyEObject).setAccessedTarget(((VariableAccess) eObject).getTargetVariable());
        }
    }
}
