
package org.ow2.dsrg.fm.qabstractor.utils;

import de.fzi.gast.accesses.impl.accessesPackageImpl;
import de.fzi.gast.core.Root;
import de.fzi.gast.core.impl.corePackageImpl;
import de.fzi.gast.expressions.impl.expressionsPackageImpl;
import de.fzi.gast.functions.impl.functionsPackageImpl;
import de.fzi.gast.statements.impl.statementsPackageImpl;
import de.fzi.gast.types.impl.typesPackageImpl;
import de.fzi.gast.variables.impl.variablesPackageImpl;
import eu.qimpress.samm.staticstructure.Repository;
import eu.qimpress.samm.staticstructure.impl.StaticstructurePackageImpl;
import eu.qimpress.sourcecodedecorator.SourceCodeDecoratorRepository;
import eu.qimpress.sourcecodedecorator.impl.SourceCodeDecoratorPackageImpl;
import java.io.IOException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;

/**
 * Utility class to load serialized emf models.
 * NOTE: After eclipse integration is not needed anymore.
 * NOTE: all files must have .xml extension
 * @author Josef Reidinger
 */
public class EResourceLoader {
    /**
     * load SourceDecorator.
     * NOTE: It doesn't load correctly cross references and instead create new
     * objects. That should be improved as created objects is useless.
     * @param path to file
     * @return loaded source decorator
     * @throws IOException if problems with file occur
     */
    public static SourceCodeDecoratorRepository loadSourceDecorator(String path) throws IOException{
    	///FIXME it doesn't load cross reference, so it is useless
        functionsPackageImpl.eINSTANCE.eClass();
        SourceCodeDecoratorPackageImpl.eINSTANCE.eClass();
        StaticstructurePackageImpl.eINSTANCE.eClass();
        return (SourceCodeDecoratorRepository)loadXML(path);
    }

    /**
     * Loads GAST root element
     * @param file to load
     * @return GAST root element
     * @throws IOException if problems with file occur
     */
     public static Root loadGASTRoot(String file) throws IOException {

      
        corePackageImpl.eINSTANCE.eClass();
        accessesPackageImpl.eINSTANCE.eClass();
        expressionsPackageImpl.eINSTANCE.eClass();
        functionsPackageImpl.eINSTANCE.eClass();
        statementsPackageImpl.eINSTANCE.eClass();
        typesPackageImpl.eINSTANCE.eClass();
        variablesPackageImpl.eINSTANCE.eClass();
        return (Root) loadXML(file);
    }

     /**
      * Loads component Repository.
      * @param path to file
      * @return loaded component repository.
      * @throws IOException if problems with file occur
      */
     public static Repository loadComponentRepository(String path) throws IOException{


        functionsPackageImpl.eINSTANCE.eClass();
        SourceCodeDecoratorPackageImpl.eINSTANCE.eClass();
        StaticstructurePackageImpl.eINSTANCE.eClass();


        return (Repository)loadXML(path);
    }

     /**
      * universal xml loader. All EMF model packages must be registered in
      * EMF resource registry.
      * @param file to load
      * @return loaded EMF Object
      * @throws IOException if problems with file occur
      */
     private static EObject loadXML (String file) throws IOException{
         ResourceSet rs = new ResourceSetImpl();

         //register extension
         rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put(
                "xml", new XMIResourceFactoryImpl());


        URI uri = URI.createFileURI(file);

        Resource resource = rs.createResource(uri);
        resource.load(null);
        return resource.getContents().get(0);
     }
}
