
package org.ow2.dsrg.fm.qabstractor.utils;

import de.fzi.gast.types.GASTClass;
import java.util.Comparator;

/**
 * Utility class which compares two gast class. To compare is used fully
 * qualified class name.
 * Used mainly in sets.
 * @author Josef Reidinger
 */
public class ClassComparator implements Comparator<GASTClass>{

    @Override
    public int compare(GASTClass o1, GASTClass o2) {
        return o1.getQualifiedName().compareTo(o2.getQualifiedName());
    }

}
