package org.ow2.dsrg.fm.qabstractor.transformation;

import org.apache.log4j.Logger;
import org.ow2.dsrg.fm.qabstractor.Transformer;
import org.ow2.dsrg.fm.qabstractor.extract.MetadataExtractor;

import de.fzi.gast.statements.BlockStatement;
import de.fzi.gast.statements.LoopStatement;
import de.fzi.gast.statements.LoopStatementKind;
import de.fzi.gast.statements.SimpleStatement;
import de.fzi.gast.statements.statementsFactory;
import de.fzi.gast.statements.impl.statementsFactoryImpl;

/**
 * Loop Unifier transformation transform different kind of loops to one type
 * 'while'.
 * @author Josef Reidinger
 */
public class LoopUnifier extends Transformation {

    public LoopUnifier(MetadataExtractor extractor) {
        super(Logger.getLogger(Transformer.class), extractor);
    }

    /**
     * Transforms different kind of loops to 'while'.
     * @param loop
     */
    @Override
    protected void processLoop(LoopStatement loop) {
        super.processLoop(loop);
        statementsFactory sFactory = new statementsFactoryImpl();
        switch (loop.getKind()) {
            case WHILE:
                return;
            case FOR: {
                BlockStatement outBlock = sFactory.createBlockStatement();
                BlockStatement inBlock = sFactory.createBlockStatement();
                SimpleStatement init = sFactory.createSimpleStatement();
                init.setExpression(loop.getInitExpression());
                SimpleStatement inc = sFactory.createSimpleStatement();
                inc.setExpression(loop.getIncrementExpression());
                inBlock.getStatements().add(loop.getBody());
                inBlock.getStatements().add(inc);
                loop.setBody(inBlock);
                outBlock.getStatements().add(init);
                outBlock.getStatements().add(loop);
                replaceStatement(loop, outBlock);
            }
            break;
            case DOWHILE: {
                BlockStatement outBlock = sFactory.createBlockStatement();
                BlockStatement inBlock = sFactory.createBlockStatement();
                outBlock.getStatements().add(loop.getBody());
                outBlock.getStatements().add(loop);
                SimpleStatement inc = sFactory.createSimpleStatement();
                inc.setExpression(loop.getIncrementExpression());
                inBlock.getStatements().add(loop.getBody());
                inBlock.getStatements().add(inc);
                loop.setBody(inBlock);
                replaceStatement(loop, outBlock);
            }
            break;
            case FOREACH: {
                BlockStatement outBlock = sFactory.createBlockStatement();
                SimpleStatement init = sFactory.createSimpleStatement();
                init.setExpression(loop.getInitExpression());
                outBlock.getStatements().add(init);
                outBlock.getStatements().add(loop);
                replaceStatement(loop, outBlock);
            }
        }
        loop.setKind(LoopStatementKind.WHILE);
    }
}
