

package org.ow2.dsrg.fm.qabstractor.transformation;

import java.util.Vector;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.ow2.dsrg.fm.qabstractor.Settings;
import org.ow2.dsrg.fm.qabstractor.Transformer;
import org.ow2.dsrg.fm.qabstractor.extract.MetadataExtractor;

import de.fzi.gast.functions.Method;
import de.fzi.gast.statements.BlockStatement;
import de.fzi.gast.statements.Branch;
import de.fzi.gast.statements.BranchStatement;
import de.fzi.gast.statements.JumpStatement;
import de.fzi.gast.statements.JumpStatementKind;
import de.fzi.gast.statements.Statement;
import de.fzi.gast.statements.statementsFactory;

/**
 * Transformation place all code after return jump to conditional execution
 * because return is not allowed in BP and also it can cause problems during
 * inlining. So if some block contain return statement, then all statements which
 * should be executed is enclosed to conditional execution.
 * This transformation is optional.
 * @see Settings#isReplacedReturns() 
 * @author Josef Reidinger
 */
public class JumpReplacer extends Transformation{

    private boolean needReturnBranch;

    public JumpReplacer(MetadataExtractor extr) {
        super(Logger.getLogger(Transformer.class),extr);
    }

    /**
     * Except common functionality reset flag if statements must be enclosed.
     * @see Transformation#processMethod(de.fzi.gast.functions.Method)
     * @param method to process
     */
    @Override
    protected void processMethod(Method method) {
        needReturnBranch = false;
        super.processMethod(method);
    }

    

    /**
     * Identifies return statement and set corresponding flag
     * @param jumpStatement to identify
     */
    @Override
    protected void processJumpStatement(JumpStatement jumpStatement) {
        super.processJumpStatement(jumpStatement);
        if (jumpStatement.getKind().equals(JumpStatementKind.RETURN)){
            needReturnBranch = true;
        }
    }



    /**
     * If find any return jump (even deeply in some another statements), then
     * escape rest of statements in block.
     * @param block
     */
    @Override
    protected void processBlock(BlockStatement block) {
        boolean needBranchRet = false;
        EList<Statement> list = block.getStatements();
        //copy to avoid concuremtn exception
        Vector<Statement> proces = new Vector<Statement>(list);
        for (int i = 0; i<proces.size();++i) {
            processStatement(proces.get(i));
            if (needReturnBranch){
                needBranchRet = true;
                BlockStatement newbl = statementsFactory.eINSTANCE.createBlockStatement();
                //set remaining statements to new block
                for (++i;i<proces.size();++i){
                    newbl.getStatements().add(proces.get(i));
                }
                Branch newbr = statementsFactory.eINSTANCE.createBranch();
                newbr.setStatement(newbl);
                BranchStatement newbs = statementsFactory.eINSTANCE.createBranchStatement();
                newbs.getBranches().add(newbr);
                processStatement(newbs);
                block.getStatements().add(newbs);
            }
        }
        needReturnBranch = needBranchRet;
    }


}
