/**
 * 
 */
package org.ow2.dsrg.fm.qabstractor.pointsto;

import java.util.Set;
import java.util.TreeSet;


import soot.Body;
import soot.Local;
import soot.Main;
import soot.PointsToAnalysis;
import soot.Scene;
import soot.Type;
import soot.jimple.toolkits.callgraph.CallGraphBuilder;

import de.fzi.gast.core.Root;
import de.fzi.gast.functions.Method;
import de.fzi.gast.variables.Field;
import de.fzi.gast.variables.LocalVariable;
import de.fzi.gast.variables.Variable;

/**
 * Soot points-to analyzer. Uses soot for implement points to analysis.
 * @author Josef Reidinger
 */
public class SootAnalyzer extends DummyRuntimeClassResolver {

    /**
     * Creates soot call graph and points-to analysis result.
     * @param classPath classpath of project
     * @param mainClass main class from which is graph constructed
     * @param root Gast tree for traversing class hierarchy
     */
    public SootAnalyzer(String classPath, String mainClass, Root root) {
        super(root);
        String[] args = new String[]{
            //"-app",
            "-w",
            "-pp",
            "-cp",
            classPath,
            "-p",
            "jb",
            "use-original-names",
            "-p",
            "cg.spark",
            "enabled",
            "-f",
            "J",
            "-outjar",
            mainClass
        };
        Main.main(args);
        CallGraphBuilder builder = new CallGraphBuilder(Scene.v().getPointsToAnalysis());
        Scene.v().setCallGraph(builder.getCallGraph());
    }

    /**
     * Not supported now.
     * @param f
     * @return
     */
    @Override
    public Set<Reference> getFieldReferences(Field f) {
        throw new UnsupportedOperationException();
    }

    /**
     * SootAnalyzer now gets result only for local variables. For rest variables
     * it uses DummyRuntimeClassResolver
     * @see DummyRuntimeClassResolver
     * @param var to analysis
     * @return set of fully qualified names of possible runtime type of var
     */
    @Override
    public Set<String> getRuntimeType(Variable var) {
        if (var instanceof LocalVariable) {
            PointsToAnalysis analysis = Scene.v().getPointsToAnalysis();
            Set<String> ret = new TreeSet<String>();
            LocalVariable lvar = (LocalVariable) var;
            assert lvar.getSurroundingFunction() instanceof Method : "Points to analysis support only methods";
            Body b = Scene.v().getSootClass(((Method) lvar.getSurroundingFunction()).getSurroundingClass().getQualifiedName()).
                    getMethodByName(lvar.getSurroundingFunction().getSimpleName()).getActiveBody();
            for (Local l : b.getLocals()) {
                //check name and type
                if (l.getName().equals(var.getSimpleName()) && l.getType().toString().equals(var.getType().getQualifiedName())) {
                    for (Type t : analysis.reachingObjects(l).possibleTypes()) {
                        ret.add(t.toString());
                    }
                }
            }
        }

        return super.getRuntimeType(var);
    }
}
