package org.ow2.dsrg.fm.qabstractor.pointsto;

/**
 * Reference is class which is used to references in points-to analysis.
 * If references points to same data then it is equal.
 * @author Josef Reidinger
 */
public class Reference implements Comparable<Reference> {

    private Integer id;
    private String name;

    /**
     * Creates new reference.
     * @param id unique reference must have unique id
     * @param name runtime type of referenced data
     */
    Reference(Integer id, String name) {
        this.id = id;
        this.name = name;
    }

    /**
     * Compares if two references points to same data.
     * @param o reference to compare
     * @return true if reference points to same data
     */
    @Override
    public boolean equals(Object reference) {
        if (reference instanceof Reference) {
            return id.equals(((Reference) reference).id);
        }

        return super.equals(reference);
    }

    @Override
    public int hashCode() {
        return id+name.hashCode();
    }

    @Override
    public int compareTo(Reference o) {
        return id - o.id;
    }

    /**
     * Gets runtime class where this reference point
     * @return the fully qualified name
     */
    public String getRuntimeClass() {
        return name;
    }
}
