package org.ow2.dsrg.fm.qabstractor.pointsto;

import java.util.Set;

import de.fzi.gast.accesses.FunctionAccess;
import de.fzi.gast.expressions.MemberAccessor;
import de.fzi.gast.variables.Field;
import de.fzi.gast.variables.Variable;

/**
 * Generic interface for any implementation of points to analysis.
 * @author Josef Reidinger
 */
public interface PointsTo {

	/**
	 * Gets possible references stored in field with runtime classes.
         * It should not be defined if transformation doesn't produce TBP with
         * data (current implentation).
	 * @param f field gast representation
	 * @return Pair of fully qualified runtime class name and unique identificator of reference
	 */
	Set<Reference> getFieldReferences(Field f);
	
	/**
	 * Gets runtime class on which is called method
	 * @param call gast expression representation of function call
	 * @return set of runtime classes represented as string
	 */
	Set<String> getRuntimeClass(MemberAccessor call);

        /**
	 * Gets runtime class on which is called method.
         * This variant is used when gast tree doesn't contain expressions.
	 * @param call gast access to method call
         * @param var variable on which is call invoked
	 * @return set of runtime classes represented as string
	 */
	Set<String> getRuntimeClass(FunctionAccess call, Variable var);
}