/**
 * 
 */
package org.ow2.dsrg.fm.qabstractor.pointsto;

import java.util.Set;
import java.util.TreeSet;

import org.ow2.dsrg.fm.qabstractor.utils.ClassFinder;

import de.fzi.gast.accesses.FunctionAccess;
import de.fzi.gast.core.Root;
import de.fzi.gast.expressions.FunctionCall;
import de.fzi.gast.expressions.MemberAccessor;
import de.fzi.gast.expressions.Variable;
import de.fzi.gast.functions.Function;
import de.fzi.gast.functions.Method;
import de.fzi.gast.types.GASTClass;
import de.fzi.gast.types.GASTType;
import de.fzi.gast.variables.Field;

/**
 * Dummy points to analyzer. It returns all possible runtime types so result is
 * always correct but contain unnecessary lot of possible classes.
 * It can be used as base for smarted points-to analysis.
 * @author Josef Reidinger
 */
public class DummyRuntimeClassResolver implements PointsTo {

    private Root rootElement;

    public DummyRuntimeClassResolver(Root rootElement) {
        this.rootElement = rootElement;
    }

    /**
     * Dummy runtime type finding which goes thrue all classes and finding each
     * class which has variable type as ancestor.
     *
     * Smarted points-to analysis should override just this method and provide
     * more precise output.
     *
     * @param var full gast variable specification
     * @return set of all possible runtime type of given variable
     */
    public Set<String> getRuntimeType(de.fzi.gast.variables.Variable var) {
        Set<String> ret = new TreeSet<String>();
        GASTType t = var.getType();        
        ret.add(t.getQualifiedName());        
        for (de.fzi.gast.core.Package pac : rootElement.getPackages()) {
            for (GASTClass clas : pac.getClasses()) {
                for (GASTClass clas2 : ClassFinder.getAllInner(clas))
                {                    
                    for (GASTClass sup : ClassFinder.getAllAncestors(clas2)) {
                        if (sup.getQualifiedName().equals(t.getQualifiedName())) {
                            ret.add(clas2.getQualifiedName());
                            break;
                        }
                    }                    
                }
            }
        }

        return ret;
    }

    /*
     * (non-Javadoc)
     *
     * @see
     * org.ow2.dsrg.fm.jababstractor2.pointsto.PointsTo#getRuntimeClass(de.fzi
     * .gast.functions.Function)
     */
    @Override
    public Set<String> getRuntimeClass(MemberAccessor call) {
        if (!( call.getLeft() instanceof Variable && call.getRight() instanceof FunctionCall)){
            return null; //TODO exception
        }
        return getRuntimeClass(((FunctionCall)call.getRight()).getFunction(),
                ((Variable) call.getLeft()).getVariableAccess().getTargetVariable());
    }

    /**
     * Dummy implementation which returns empty set of possible references.
     * @param f full gast information about field
     * @return set of possible reference targets of field
     */
    @Override
    public Set<Reference> getFieldReferences(Field f) {
        return new TreeSet<Reference>();
    }

    /**
     * Gets runtime class for specified call and variable.
     * At first it find all possible type of variable and then find which
     * ancestor define that call.
     * @param call information about called method
     * @param var information about variable on which is call invoked
     * @return Set of fully qualified class names which is possible classes
     *          which body should be taken as executed one
     */
    @Override
    public Set<String> getRuntimeClass(FunctionAccess call,
            de.fzi.gast.variables.Variable var) {
        Function f = call.getTargetFunction();
        Set<String> runtimeClasses = getRuntimeType(var);
        Set<String> ret = new TreeSet<String>();
        other_rt_class:
        for (String str : runtimeClasses) {
            // find class where body is defined
            GASTClass clas = ClassFinder.getClassByQualifiedName(rootElement,
                    str.replace('$', '.')); //stupid gast names
            if (clas == null) { // not available
                // TODO log
                continue;
            }
            for (Method m : clas.getMethods()) {
                if (m.getSimpleName().equals(f.getSimpleName()) && m.getFormalParameters().equals(
                        f.getFormalParameters())) {
                    ret.add(clas.getQualifiedName().replace('$', '.'));
                    continue other_rt_class;
                }
            }
            // search super types
            for (GASTClass cl : ClassFinder.getAllAncestors(clas)) {
                for (Method m : cl.getMethods()) {
                    if (m.getSimpleName().equals(f.getSimpleName()) && m.getFormalParameters().equals(
                            f.getFormalParameters())) {
                        ret.add(cl.getQualifiedName().replace('$', '.'));
                        continue other_rt_class;
                    }
                }
            }
        }

        return ret;
    }
}
