/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.ow2.dsrg.fm.qabstractor.extract;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import org.ow2.dsrg.fm.qabstractor.Settings;

import de.fzi.gast.functions.Method;
import de.fzi.gast.types.GASTClass;

/**
 *
 * @author JR
 */



public class MetadataExtractorImpl implements MetadataExtractor {

	public static class ComponentInfo {
		private String component;
		private Set<GASTClass> implClasses = new HashSet<GASTClass>();
		private GASTClass extractedClass;		
		private HashMap<Method, String> requiredMethods = new HashMap<Method, String>();
		private HashMap<Method, String> providedMethods = new HashMap<Method, String>(); 
		
		public ComponentInfo(String cName) {
			component = cName;
		}
		
		
		public void addImplClass(GASTClass implClass){
			implClasses.add(implClass);
			addImplClasses(implClass.getInnerClasses());
			
			if (Settings.instance().isIncludeInterface()) {	        	
        		for (GASTClass gc : implClass.getSuperTypes()) {
                    if (gc.isInterface()) {
                    	addImplClass(gc);
                    }
                }
			}
		}
		
		public void addImplClasses(Collection<GASTClass> _implClasses) {
			for (GASTClass cls:_implClasses){			
				addImplClass(cls);
			}
		}
		
		public void addProvidedMethod(Method m, String modelName) {
			providedMethods.put(m, modelName);
		}
		
		public void addProvidedMethods(Map<Method, String> _providedMethods) {
			providedMethods.putAll(_providedMethods);
		}
		
		public void addRequiredMethod(Method m, String modelName) {
			requiredMethods.put(m, modelName);
		}
		
		
		public void addRequiredMethods(Map<Method, String> _requiredMethods) {
			requiredMethods.putAll(_requiredMethods);
		}
		
		public Set<GASTClass> getImplClasses() {
			return Collections.unmodifiableSet(implClasses);
		}
		
		public Map<Method, String> getProvidedMethods() {
			return Collections.unmodifiableMap(providedMethods);
		}
		
		public Map<Method, String> getRequiredMethods() {
			return Collections.unmodifiableMap(requiredMethods);
		}

		
	    private void appendMethodInfo(StringBuffer sb, Method m){
	    	sb.append(m.getSurroundingClass().getSimpleName()+"::"+m.getSimpleName()+" ");
	    }
				
		public void toStringBuffer(StringBuffer sb) {
			sb.append("Component: "+component+"\n");
    		sb.append("\t implemented by: "+implClasses+"\n");
    		
    		sb.append("\t provided methods: ");
    		for (Method m: providedMethods.keySet()){
    			appendMethodInfo(sb, m);
    		}
    		sb.append("\n");
    		
    		sb.append("\t required methods: ");
    		for (Method m: requiredMethods.keySet()){
    			appendMethodInfo(sb, m);
    		}
    		sb.append("\n");    	
    		}	
		
		
	    public void setExtractedClass(GASTClass c){
	    	extractedClass = c;
	    }
	    
	    public GASTClass getExtractedClass() {
			return extractedClass;
		}
	}

	private Map<String, ComponentInfo> components = new HashMap<String, ComponentInfo>();
	
    private ComponentInfo getComponentInfo(String cName){
    	ComponentInfo ci = components.get(cName);
    	if (ci == null){
    		ci = new ComponentInfo(cName);
    		components.put(cName,ci);
    	}
    	
    	return ci;
    }
    
    
    @Override
    public String toString() {
    	StringBuffer sb = new StringBuffer();
    	sb.append("Architectural info:\n");
    	
    	for (ComponentInfo ci:components.values()){
    		ci.toStringBuffer(sb);
    	}
    	
    	return sb.toString();
    }
    

    public void addImplClasses(String cName, Collection<GASTClass> implCl) {
    	getComponentInfo(cName).addImplClasses(implCl);
    }

    public void addImplClass(String cName, GASTClass implCl) {
    	getComponentInfo(cName).addImplClass(implCl);
    }
    
    public void addProvidedMethods(String cname, Map<Method, String> providedMethods) {
    	getComponentInfo(cname).addProvidedMethods(providedMethods);
    }

    public void addProvidedMethod(String cname, Method m, String modelName) {
    	getComponentInfo(cname).addProvidedMethod(m, modelName);
    }

    
    public void addRequiredMethod(String cname, Method m, String modelName) {
    	getComponentInfo(cname).addRequiredMethod(m, modelName);
    }
    
    public void addRequiredMethods(String cname, Map<Method, String> requiredMethods) {
    	getComponentInfo(cname).addRequiredMethods(requiredMethods);
    }
    
    @Override
    public Set<GASTClass> getImplClasses(String name) {
        return components.get(name).getImplClasses();
    }
    
    @Override
    public Set<Method> getProvidedMethods(String name) {
        return components.get(name).getProvidedMethods().keySet();
    }

    @Override
    public Set<Method> getRequiredMethods(String name) {
        return components.get(name).getRequiredMethods().keySet();
    }
    
    @Override
    public Set<String> getComponents() {
        return components.keySet();
    }

    /*public void setComponents(Set<String> components) {
        this.components = components;
    }*/

    @Override
    public String getInterfaceForProvidedMethod(String component, Method method){
        //manually search thrue key set as provided method should be moved
        //between classes and interface is needed only in final step where
        //simple name is unique
    	Map<Method, String> providedMethods = components.get(component).providedMethods;
        for (Method m : providedMethods.keySet()) {
            if (m.getSimpleName().equals(method.getSimpleName())) {
                return providedMethods.get(m);
            }
        }
        if (method.getSimpleName().matches("Thread_.*_run")) {
            return "Thread"; //FIXME is it proper name?
        }
        //should not happen as final GAST class contain only provided interface
        assert false : "Cannot find the interface for a method which is provided";
        return "interface";
    }

    @Override
    public String getInterfaceForRequiredMethod(String component, Method method){
    	Map<Method, String> requiredMethods = components.get(component).requiredMethods;
         String result = requiredMethods.get(method);
         if (result == null){
             //should not happen as required method is identified by keyset
             assert false : "Cannot find the interface for a method which is required";
             return "interface";
         }
         return result;
    }
    

    
    public boolean isKnown(GASTClass c) {
    	for (ComponentInfo ci:components.values()){
    		if (ci.implClasses.contains(c)){
    			return true;
    		}
    	}
    	
    	return false;
    	
    }
    
    public void setExtractedClass(String componentName, GASTClass c){
    	components.get(componentName).setExtractedClass(c);    	
    }
    
    public GASTClass getExtractedClass(String componentName) {
    	return components.get(componentName).getExtractedClass();
	}
}
