/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.ow2.dsrg.fm.qabstractor.exception;

import de.fzi.gast.core.Position;

/**
 * Marks exception that is caused by bad code in analysed sources. Provides
 * information about position of this code.
 * @author Josef Reidinger
 */
public class CodeException extends RuntimeException {

    private Position position;

    public CodeException(String message, Position position) {
        super("Problematic code found in file " + (position.getSourceFile() == null ? "unknown" : position.getSourceFile().toString()) + " between lines " + position.getStartLine() + "-" + position.getEndLine() + ": \n" + message);
        this.position = position;
    }

    /**
     * Gets position of problematic code.
     * @return position of code, it contains same data as in gast
     */
    public Position getPosition() {
        return position;
    }
}
