package org.ow2.dsrg.fm.qabstractor;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

import org.ow2.dsrg.fm.qabstractor.exception.CodeException;
import org.ow2.dsrg.fm.qabstractor.exception.ComponentSpecificationException;
import org.ow2.dsrg.fm.qabstractor.extract.MetadataExtractor;
import org.ow2.dsrg.fm.qabstractor.extract.SpecFileLoader;
import org.ow2.dsrg.fm.qabstractor.utils.EResourceLoader;

import de.fzi.gast.core.Root;

/**
 * Command line interface to Q-Abstractor
 * @author JR
 */
public class Main {

    /**
     *
     * @param args     
     */
    public static void main(String[] args) {
        try {
            //logging
            FileHandler fh = new FileHandler("transformation.log");
            Logger logger = Logger.getLogger("");
            for (Handler h : logger.getHandlers())
                logger.removeHandler(h);
            logger.addHandler(fh);
            logger = Logger.getLogger("jabstractor.transform");
            logger.setLevel(Level.ALL);
            ConsoleHandler cs = new ConsoleHandler();
            cs.setLevel(Level.ALL);
            cs.setFormatter(new Formatter() {

                @Override
                public String format(LogRecord record) {
                    String prefix = record.getLevel().equals(Level.FINER) ? "  ":"";
                    return prefix+record.getMessage()+"\n";
                }
            });
            logger.addHandler(cs);

        } catch (IOException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        } catch (SecurityException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }
       
        if (args.length != 2 && args.length != 4) {
            usage();
        } else {
            try {
                int begin = 0;
                if (args.length == 4) {
                    begin = 2;
                    if (!(args[0].equals("--conf"))) {
                        usage();
                        return;
                    }
                    Settings.instance().loadFromFile(args[1]);
                }
                Root r = EResourceLoader.loadGASTRoot(args[begin]);                
                MetadataExtractor extr = SpecFileLoader.loadSpecFile(args[begin + 1], r);
                Transformer.transform("", r, extr, null);
            } catch (FileNotFoundException ex) {
                System.out.println(ex.getMessage());
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            } catch (IOException ex) {
                System.out.println(ex.getMessage());
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            } catch (CodeException ce) {
                System.out.println("Analysed code contains unexped code:");
                System.out.println(ce.getMessage());
            } catch (ComponentSpecificationException se) {
                System.out.println("Component specification contains error:");
                System.out.println(se.getMessage());
            } catch (Settings.ConfigurationError e) {
                System.out.println("Configuration specification contains error:");
                System.out.println(e.getMessage());
            }
        }
    }

    private static void usage() {
        System.err.println("Usage - emfjabstractor [--conf <file>] <gast.xml> <specfile>");
    }
}
