package org.somox.analyzerrules;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

import org.apache.log4j.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

/**
 * Storage class for metric configurations. Loads the metric configuration from a bundle resource
 * @author Klaus Krogmann, Grischa Liebel, Steffen Becker
 */
public class ModelAnalyzerWeights {
	
	private static final String CONFIG_SIMPLE_ANALYZER_PROPERTIES_FILE = "config/SimpleAnalyzer.properties";
	private static Logger logger = Logger.getLogger(ModelAnalyzerWeights.class);
	private static Properties properties = null;
	
	static {
		try {
			properties = loadProperties();
		} catch (AnalyzerRuleException e) {
			properties = null;
		}
	}
	
	/**
	 * Load metric configuration from installed bundle's resource
	 * @return The metric configuration map
	 * @throws AnalyzerRuleException throw in case of IOExceptions
	 */
	private static Properties loadProperties() throws AnalyzerRuleException {
		Properties properties = new Properties();
	    Bundle bundle = Platform.getBundle("org.somox.analyzer.sissymodelanalyzer");
	    Path path = new Path(CONFIG_SIMPLE_ANALYZER_PROPERTIES_FILE);
	    URL fileURL = FileLocator.find(bundle, path, null);
	
	    try {
	    	InputStream in = fileURL.openStream();
	        properties.load(in);
	    } catch (IOException e) {
			logger.error("Failed to retrieve metric configuration: " + e);
			throw new AnalyzerRuleException("Failed to retrieve metric configuration",e);
	    }
	    return properties;
	}
	
	/**
	 * Retrieve the metric configuration from the installed bundle
	 * @return The metric configuration from the installed bundle
	 * @throws AnalyzerRuleException thrown if the metric configuration is unavailable
	 */
	public static Properties getProperties() throws AnalyzerRuleException {
		if (properties == null)
			throw new AnalyzerRuleException("No analyzer properties found. Analzyer not installed correctly.", null);
		
		return properties;
	}
	
	/**
	 * Dissalow creation of instances of this class 
	 */
	private ModelAnalyzerWeights() {}
}
