package org.somox.analyzerrules;

import java.util.Map;


/**
 * Interface for a strategy pattern used to parameterize the way the overall metric is being computed.
 * @author Grischa Liebel, Klaus Krogmann, Steffen Becker
 */
public interface IAnalyzerRule {
	/**
	 * Computes the overall value of all metrics.
	 * Both metrics values (argA and argB) must refer to the same model elements. 
	 * @param argAB metrics result for A, B 
	 * @param argBA metrics result for B, A
	 * @return Overall value for multiple metrics, taking for example
	 * interdependencies into account. Value: [0..1]
	 * @throws AnalyzerRuleException thrown if the computation of the overall metric encounters a non-recoverable error
	 */
	public double computeOverallMetricValue(Map<Integer,Double> argAB, Map<Integer,Double> argBA) throws AnalyzerRuleException;
	
}
