package org.somox.analyzer.simplemodelanalyzer.detection;

import org.apache.log4j.Logger;
import org.somox.configuration.SoMoXConfiguration.ComponentDetectionStrategy;

public class ComponentDetectionStrategyFactory {
	private static Logger logger = Logger.getLogger(ComponentDetectionStrategyFactory.class);
	
	public static IDetectionStrategy createDetectionStrategy(ComponentDetectionStrategy usedStrategy){
		switch(usedStrategy){
		case BYCLUSTERING:
			logger.info("Use Clustering Detection Strategy");
			return new ComponentDetectionByClustering();
		case BYDIRECTORY:
			logger.info("Use Directory Structure Detection Strategy");
			return new ComponentDetectionByDirectoryStructure();
		}
		throw new RuntimeException("Tried to use unknown component detection strategy");
	}
}
