package org.somox.analyzer.simplemodelanalyzer.detection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.somox.analyzer.simplemodelanalyzer.ComponentDetectionResult;
import org.somox.analyzer.simplemodelanalyzer.SimpleAnalysisResult;
import org.somox.configuration.SoMoXConfiguration;

import de.fzi.gast.core.Directory;
import de.fzi.gast.core.File;
import de.fzi.gast.core.Position;
import de.fzi.gast.core.Root;
import de.fzi.gast.types.GASTClass;

public class ComponentDetectionByDirectoryStructure implements IDetectionStrategy {

	/**
	 * The logger of this analyser 
	 */
	private Logger logger = Logger.getLogger(ComponentDetectionByDirectoryStructure.class);
	
	/* (non-Javadoc)
	 * @see org.somox.analyzer.simplemodelanalyzer.detection.IDetectionStrategy#startDetection(de.fzi.gast.core.Root, java.util.Set, org.somox.analyzer.simplemodelanalyzer.SimpleAnalysisResult, org.somox.configuration.SoMoXConfiguration, org.eclipse.core.runtime.IProgressMonitor, java.util.List)
	 */
	public List<List<GASTClass>> startDetection(Root root, 
			SimpleAnalysisResult analysisResult,
			SoMoXConfiguration somoxConfiguration,
			IProgressMonitor progressMonitor,
			List<List<GASTClass>> filteredComponents) {
		
		
		EList<GASTClass> allclasses = collectAllClasses(root);

		logger.info("Number of found classes: "+ allclasses.size());

		progressMonitor.beginTask("Detect Components by Directory Structure", allclasses.size());
		
		ComponentDetectionResult result = calculateDirectoryToClassMapping(allclasses, progressMonitor);

		progressMonitor.done();
		
		return result.getFoundComponents();
	}	

	private EList<GASTClass> collectAllClasses(Root root) {
		EList<GASTClass> allclasses = null;
		
		allclasses = root.getAllNormalClasses();
		allclasses.addAll(root.getAllInnerClasses());
		allclasses.addAll(root.getAllLocalClasses());
		
		return null;
	}
	
    private ComponentDetectionResult calculateDirectoryToClassMapping(EList<GASTClass> allclasses, IProgressMonitor progressMonitor) {
		
		HashMap<Directory, List<GASTClass>> directory2classlistMap = new HashMap<Directory, List<GASTClass>>();
		
		List<GASTClass> restClasses = new LinkedList<GASTClass>();
		
		for (GASTClass gastclass : allclasses) {
			Directory directory = null;
			directory = getDirectoryOfGASTClass(gastclass);
			if (directory != null) {
				List<GASTClass> classlist = directory2classlistMap.get(directory);
				if (classlist == null) {
					classlist = new ArrayList<GASTClass>();
					directory2classlistMap.put(directory, classlist);
				}
				if (!classlist.contains(gastclass)) {
						classlist.add(gastclass);
				}
			} else {
				restClasses.add(gastclass);				
				logger.warn("Directory for GASTClass not found: "+ gastclass.getQualifiedName());
			}
			progressMonitor.worked(1);
		}
		
		return createResult(directory2classlistMap, restClasses);
	}

	private ComponentDetectionResult createResult(
			HashMap<Directory, List<GASTClass>> directory2classlistMap,
			List<GASTClass> restClasses) {
		ComponentDetectionResult result = new ComponentDetectionResult();
		
		result.getFoundComponents().addAll(directory2classlistMap.values());
		result.getFoundComponents().add(restClasses);
		
		return result;
	}
	
    /**
     * This method returns the directory of a gastclass. 
     * This is done via gastclass.position.sourcefile.directory.
     * 
     * @param gastclass gastclass for which directory is retrieved
     * @return directory of gastclass 
     * @return null if position, sourcefile or directory is null
     */
    private Directory getDirectoryOfGASTClass(GASTClass gastclass) {
		Directory directory = null;
		Position position = gastclass.getPosition();
		if (position != null) {
			File sourceFile = position.getSourceFile();
			if (sourceFile != null) {
				directory = sourceFile.getDirectory();
			}
		}
		
		return directory;
	}

}
