/**
 * 
 */
package org.somox.analyzer.simplemodelanalyzer.candidates.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import org.somox.analyzer.simplemodelanalyzer.candidates.IComponentCandidate;
import de.fzi.gast.types.GASTClass;

/** 
 * Abstract base class of all component candidates which use a set of {@link GASTClass} as 
 * the component's implementation
 * @author Steffen Becker
 */
public class AbstractGASTClassCandidate implements IComponentCandidate {
	
	/**
	 * The set of classes which form together the implementation of this component candidate 
	 */
	protected Set<GASTClass> componentImplementationClasses = null;

	/**
	 * @param componentImplementationClasses
	 */
	protected AbstractGASTClassCandidate(
			Set<GASTClass> componentImplementationClasses) {
		super();
		
		this.componentImplementationClasses = new HashSet<GASTClass>(componentImplementationClasses);
	}

	/**
	 * @return the componentImplementationClasses
	 */
	public Set<GASTClass> getComponentImplementationClasses() {
		return Collections.unmodifiableSet(componentImplementationClasses);
	}
	
}
