package org.somox.analyzer.simplemodelanalyzer;

import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;

import de.fzi.gast.accesses.Access;
import de.fzi.gast.accesses.CompositeAccess;
import de.fzi.gast.types.GASTClass;

/**
 * Blacklist-based filtering of access types.
 * @author kelsaka
 *
 */
public class AccessFilter {
	
	private static Logger logger = Logger.getLogger(AccessFilter.class);

	/**
	 * Filters a black list of access types
	 * @param allAccesses
	 * @param blacklistedAccessTypes
	 * @return List of accessed GASTClasses after filtering blacklisted access types 
	 */
	public static List<GASTClass> filterAccessList(
			EList<Access> allAccesses, List<Class<?>> blacklistedAccessTypes) {
		ArrayList<GASTClass> returnAccessedClasses = new ArrayList<GASTClass>();

		for(Access access : allAccesses) {
			boolean isBlacklisted = false;
			for(Class<?> blackListedClass : blacklistedAccessTypes) {
				if(blackListedClass.isInstance(access)) {
					isBlacklisted = true;
				}
			}
			if(!isBlacklisted) {				
				if(access.getAccessedClass() != null) { // composite accesses are not considered
					returnAccessedClasses.add(access.getAccessedClass());
				} else {					
					if(!(access instanceof CompositeAccess)) {
						// not composite access
						logger.warn("found empty access: accessed class null, "+ access.getSissyId());
					}
				}
			}
		}
		
		return returnAccessedClasses;
	}
}
