package org.somox.analyzer.simplemodelanalyzer;

import java.util.List;

import de.fzi.gast.types.GASTClass;
import eu.qimpress.qimpressgast.GASTBehaviourRepository;
import eu.qimpress.samm.staticstructure.Repository;
import eu.qimpress.sourcecodedecorator.SourceCodeDecoratorRepository;

public abstract class AbstractSammModelBuilder {

	private Repository sammRepository;
	private GASTBehaviourRepository gastBehaviourRepository;
	private SourceCodeDecoratorRepository source2architectureMappingRepository;
	
	public AbstractSammModelBuilder(Repository sammRepository,
			GASTBehaviourRepository gastBehaviourRepository,
			SourceCodeDecoratorRepository source2architectureMappingRepository) {
		super();
		this.sammRepository = sammRepository;
		this.gastBehaviourRepository = gastBehaviourRepository;
		this.source2architectureMappingRepository = source2architectureMappingRepository;
	}
	
	public void buildSAMMModel(List<List<GASTClass>> componentsClassLists) {
		buildComponents(componentsClassLists);
	}

	private void buildComponents(List<List<GASTClass>> componentsClassLists) {
		for (List<GASTClass> component : componentsClassLists) {
			buildComponentForClassList(component);
		}
	}

	public abstract void buildComponentForClassList(List<GASTClass> component);

}
