package org.somox.analyzer.metriccomputation;

import java.util.List;

import de.fzi.gast.types.GASTClass;

/**
 * This class stores the computed metric of the relationship between component A and component B
 * @author  Klaus Krogmann, Steffen Becker
 */
public class ClusteringRelation {
	/**
	 * @uml.property  name="componentA"
	 */
	private List<GASTClass> componentA;
	/**
	 * @uml.property  name="componentB"
	 */
	private List<GASTClass> componentB;
	/**
	 * @uml.property  name="result"
	 */
	private double result;
	
	public ClusteringRelation (List<GASTClass> componentA, List<GASTClass> componentB) {
		this.componentA = componentA;
		this.componentB = componentB;		
	}
	
	/**
	 * @param componentA
	 * @uml.property  name="componentA"
	 */
	public void setComponentA(List<GASTClass> componentA) {
		this.componentA = componentA;
	}
	
	/**
	 * @return
	 * @uml.property  name="componentA"
	 */
	public List<GASTClass> getComponentA() {
		return componentA;
	}
	
	/**
	 * @param componentB
	 * @uml.property  name="componentB"
	 */
	public void setComponentB(List<GASTClass> componentB) {
		this.componentB = componentB;
	}
	
	/**
	 * @return
	 * @uml.property  name="componentB"
	 */
	public List<GASTClass> getComponentB() {
		return componentB;
	}
	
	/**
	 * @param result
	 * @uml.property  name="result"
	 */
	public void setResult (double result) {
		this.result = result;
	}
	
	/**
	 * @return
	 * @uml.property  name="result"
	 */
	public double getResult() {
		return result;
	}
}
