package de.uka.ipd.sdq.sensorframework.dao.file.entities;




import java.util.HashMap;
import java.util.Map;

import de.uka.ipd.sdq.sensorframework.entities.ScalabilityExperimentRun;
import de.uka.ipd.sdq.sensorframework.entities.dao.IDAOFactory;

/**
 * Entity implementation for scalability Experiment Runs. 
 * Contains BackgroundMemoryLists to quickly store the 
 * huge amounts of sensor data generated by simulations.
 * 
 * @author Paul-Remis Beauvais
 * 
 */
public class ScalabilityExperimentRunImpl extends ExperimentRunImpl 
implements ScalabilityExperimentRun {

	private static final long serialVersionUID = 8596657460961660218L;

	private String[] paramNames = null;
	
	private Map<String, Integer> constParameters = 
		new HashMap<String, Integer>();
	
	public ScalabilityExperimentRunImpl(IDAOFactory factory) {
		super(factory);
	}
	
	public void addConstParameter(String paramName, int paramValue) {
		constParameters.put(paramName, paramValue);
	}
	
	public Map<String, Integer> getConstParameters() {
		return constParameters;
	}
	
	public String[] getVarParameterNames() {
		return paramNames;
	}
	
	public void setVarParameterNames(String[] names) {
		paramNames = names;
	}
	
	
}

