/**
 * This class demonstrates the use of the API of the Sensorframework Plugin from C programs. 
 * It creates an experiment, some sensors, and finally adds measurements to it. 
 * For additional examples, see the JUnit tests of the sensor framework in their 
 * own plugin.
 *
 * Requirements: # You will need the Sun Java Developer Kit (JDK). I recommend Java 1.6.0.
 *	         # Any C/C++ compiler installed.
 *
 *
 *				OTHER:
 *				java jdk home/lib/jvm.lib
 *					- minimal set of JNI functions that needed visible: 
 *						JNI_CreateJavaVM 
 *						JNI_GetDefaultJavaVMInitArgs 
 *						JNI_GetCreatedJavaVMs 
 *				DLL exports file to use with dlltool(dlltool --input-def jvm.def --kill-at -- 
 *				dllname jvm.dll --output-lib libjvm.dll.a) to build an import library libjvm.dll *				(@bytes):
 *						EXPORTS
 *						JNI_CreateJavaVM@12
 *						JNI_GetDefaultJavaVMInitArgs@4
 *						JNI_GetCreatedJavaVMs@12
 *
 *
 *
 *
 *
 *
 *
 * @author Lucia Kapova
 */
 
#include "StdAfx.h"
#include <stdio.h>
#include <jni.h>
#include <string.h>

 #define PATH_SEPARATOR ';' /* define it to be ':' on Solaris */
 #define USER_CLASSPATH "." /* where Prog.class is */


JNIEnv* create_vm(JavaVM ** jvm) {
	
    JNIEnv *env;
    JavaVMInitArgs vm_args;
    JavaVMOption options;
    options.optionString = "-Djava.class.path=D:\\Java Src\\Test"; //Path to the java source code
    vm_args.version = JNI_VERSION_1_6; //JDK version. This indicates version 1.6
    vm_args.nOptions = 1;
    vm_args.options = &options;
    vm_args.ignoreUnrecognized = 0;
    
    int ret = JNI_CreateJavaVM(jvm, (void**)&env, &vm_args);
    if(ret < 0)
    	printf("\nUnable to Launch JVM\n");   	
	return env;
}

int main(int argc, char* argv[])
{
	JNIEnv *env;
	JavaVM * jvm;
	env = create_vm(&jvm);
	if (env == NULL)
		return 1;
	
    jclass clsSensorFrameworkAPIDemo = NULL;
    jclass clsEdp2MeasurementExample = NULL;
    jmethodID midMain = NULL;
    jmethodID midStore = NULL;
    
    jobject jobj = NULL;
    jobjectArray jobjWOArr = NULL;
    
    //Obtaining Classes
    clsSensorFrameworkAPIDemo = env->FindClass("SensorFrameworkAPIDemo");
    clsSensorFrameworkAPIDemo = env->FindClass("Edp2MeasurementExample");
	
	//Obtaining Method IDs
    if (clsH != NULL)
    {
		midMain       = env->GetStaticMethodID(clsSensorFrameworkAPIDemo , "main", "([Ljava/lang/String;)V");
		/*
		midbla    = env->GetStaticMethodID(clsH,"Store","(Ljava/lang/String;)V");
		midblabla = env->GetStaticMethodID(clsH,"DisplayObj","(LControlDetail;)I");
		midDispStructArr = env->GetStaticMethodID(clsH,"DisplayObjArray","([LWorkOrder;)V");
		midRetObjFunc = env->GetStaticMethodID(clsH,"ReturnObjFunc","()Ljava/lang/Object;");
		*/
	}
	else
    {
    	printf("\nUnable to find the requested class\n");    	
    }
	if(clsC != NULL)
	{
		//Get constructor ID 
		midCtrlDetConst = env->GetMethodID(clsC, "<init>", "(ILjava/lang/String;Ljava/lang/String;I)V");		
	}
	else
    {
    	printf("\nUnable to find the requested class\n");    	
    }	

	if(clsW != NULL)
	{
		//Get Constructor ID 
		midWoConst = env->GetMethodID(clsW, "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V");		
	}
	else
    {
    	printf("\nUnable to find the requested class\n");    	
    }

	/************************************************************************/
	/* Now we will call the functions using the their method IDs			*/
	/************************************************************************/
	if(midMain != NULL)
		env->CallStaticVoidMethod(clsH, midMain, NULL); //Calling the main method.
	/*
	if (midCalling!=NULL)
	{
		jstring StringArg = env->NewStringUTF("\nTestCall:Called from the C Program\n");
		//Calling another static method and passing string type parameter
		env->CallStaticVoidMethod(clsH,midCalling,StringArg);
	}
	
	printf("\nGoing to Call DisplayStruct\n");
	if (midDispStruct!=NULL)
	{
		if(clsC != NULL && midCtrlDetConst != NULL)
		{
			jstring StringArgName = env->NewStringUTF(ctrlDetail.Name);
			jstring StringArgIP = env->NewStringUTF(ctrlDetail.IP);
			
			//Creating the Object of ControlDetail.
			jobjDet = env->NewObject(clsC, midCtrlDetConst, (jint)ctrlDetail.ID, StringArgName, StringArgIP, (jint)ctrlDetail.Port);
		}
		
		if(jobjDet != NULL && midDispStruct != NULL)
			env->CallStaticIntMethod(clsH,midDispStruct,jobjDet); //Calling the method and passing ControlDetail Object as parameter
	}
	//Calling a function from java and passing Structure array to it.
	printf("\n\nGoing to call DisplayStructArray From C\n\n");
	if (midDispStructArr!=NULL)
	{
		if(clsW != NULL && midWoConst != NULL)
		{
			//Creating the Object Array that will contain 2 structures.
			jobjWOArr = (jobjectArray)env->NewObjectArray(2,clsW,env->NewObject(clsW, midWoConst,env->NewStringUTF(""),env->NewStringUTF(""),env->NewStringUTF(""),
														  env->NewStringUTF(""),env->NewStringUTF(""),env->NewStringUTF(""),env->NewStringUTF("")));         	
			//Initializing the Array
			for(int i=0;i<2;i++)
			{
				env->SetObjectArrayElement(jobjWOArr,i,env->NewObject(clsW, midWoConst,env->NewStringUTF(WO[i].sumSerialId),
														env->NewStringUTF(WO[i].accessNumber),
														env->NewStringUTF(WO[i].actionType),
														env->NewStringUTF(WO[i].effectiveDate),
														env->NewStringUTF(WO[i].fetchFlag),
														env->NewStringUTF(WO[i].reason),
														env->NewStringUTF(WO[i].accessSource)));	
			}
		}
		//Calling the Static method and passing the Structure array to it.
		if(jobjWOArr != NULL && midDispStructArr != NULL)
			env->CallStaticVoidMethod(clsW,midDispStructArr,jobjWOArr);
	}
	//Calling a Static function that return an Object
	if (midRetObjFunc != NULL)
	{
		//Calling the function and storing the return object into jobject type variable
		//Returned object is basically a structure having two fields (string and integer)
		jobjRetData = (jobject)env->CallStaticObjectMethod(clsH,midRetObjFunc,NULL);
		//Get the class of object
		clsR = env->GetObjectClass(jobjRetData);
		//Obtaining the Fields data from the returned object
		jint nRet = env->GetIntField(jobjRetData,env->GetFieldID(clsR,"returnValue","I"));
		jstring jstrLog = (jstring)env->GetObjectField(jobjRetData,env->GetFieldID(clsR,"Log","Ljava/lang/String;"));
		const char *pLog = env->GetStringUTFChars(jstrLog,0);
		
		printf("\n\nValues Returned from Object are:\nreturnValue=%d\nLog=%s",nRet,pLog);
		//After using the String type data release it.
		env->ReleaseStringUTFChars(jstrLog,pLog);
	}
	*/
	//Release resources.
	int n = jvm->DestroyJavaVM();
    return 0;
}
 