/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.seff;

import java.util.Map;

import org.eclipse.emf.common.util.DiagnosticChain;

import eu.qimpress.samm.staticstructure.InterfacePort;
import eu.qimpress.samm.staticstructure.Operation;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>External Call Action</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * ExternalCallAction models the invocation of a service specified in a required interface. Therefore, it references a Role, from which the providing component can be derived, and a Signature to specify the called service. ExternalCallActions model synchronous calls to required services, i.e., the caller waits until the called service finishes execution before continuing execution itself. The PCM allows modelling asynchronous calls to required services by using an ExternalCallAction inside a ForkedBehaviour.
 * ExternalCallActions do not have resource demands by themselves. Component developers need to specify the resource demand of the called service in the RDSEFF of that service. The resource demand can also be calculated by analysing the providing component. This keeps the RDSEFF specification of different component developers independent from each other and makes them replaceable in an architectural model.
 * ExternalCallActions may contain two sets of VariableUsages specifying input parameter characterisations and output parameter characterisations respectively. VariableUsages for input parameters may only reference IN or INOUT parameters of the calls referenced signature. The random variable characterisation inside such a VariableUsage may be constants, probability distribution functions, or include a stochastic expression involving for example arithmetic operations. The latter models a dependency between the current services own input parameters and the input parameters of the required service.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link eu.qimpress.seff.ExternalCallAction#getCalledService <em>Called Service</em>}</li>
 *   <li>{@link eu.qimpress.seff.ExternalCallAction#getCalledInterfacePort <em>Called Interface Port</em>}</li>
 * </ul>
 * </p>
 *
 * @see eu.qimpress.seff.seffPackage#getExternalCallAction()
 * @model
 * @generated
 */
public interface ExternalCallAction extends AbstractAction {
	/**
	 * Returns the value of the '<em><b>Called Service</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Called Service</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Called Service</em>' reference.
	 * @see #setCalledService(Operation)
	 * @see eu.qimpress.seff.seffPackage#getExternalCallAction_CalledService()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	Operation getCalledService();

	/**
	 * Sets the value of the '{@link eu.qimpress.seff.ExternalCallAction#getCalledService <em>Called Service</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Called Service</em>' reference.
	 * @see #getCalledService()
	 * @generated
	 */
	void setCalledService(Operation value);

	/**
	 * Returns the value of the '<em><b>Called Interface Port</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Called Interface Port</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Called Interface Port</em>' reference.
	 * @see #setCalledInterfacePort(InterfacePort)
	 * @see eu.qimpress.seff.seffPackage#getExternalCallAction_CalledInterfacePort()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	InterfacePort getCalledInterfacePort();

	/**
	 * Sets the value of the '{@link eu.qimpress.seff.ExternalCallAction#getCalledInterfacePort <em>Called Interface Port</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Called Interface Port</em>' reference.
	 * @see #getCalledInterfacePort()
	 * @generated
	 */
	void setCalledInterfacePort(InterfacePort value);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * self.calledInterfacePort.isRequired = true
	 * @param diagnostics The chain of diagnostics to which problems are to be appended.
	 * @param context The cache of context-specific information.
	 * <!-- end-model-doc -->
	 * @model
	 * @generated
	 */
	boolean CalledInterfacePortHasToBeARequiredPort(DiagnosticChain diagnostics, Map<Object, Object> context);

} // ExternalCallAction
