/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.usagemodel.util;

import java.util.Map;

import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;

import eu.qimpress.identifier.util.IdentifierValidator;
import eu.qimpress.samm.usagemodel.*;
import eu.qimpress.samm.usagemodel.ClosedWorkload;
import eu.qimpress.samm.usagemodel.OpenWorkload;
import eu.qimpress.samm.usagemodel.SystemCall;
import eu.qimpress.samm.usagemodel.UsageModel;
import eu.qimpress.samm.usagemodel.UsageRepository;
import eu.qimpress.samm.usagemodel.UsageScenario;
import eu.qimpress.samm.usagemodel.UsagemodelPackage;
import eu.qimpress.samm.usagemodel.Workload;

/**
 * <!-- begin-user-doc -->
 * The <b>Validator</b> for the model.
 * <!-- end-user-doc -->
 * @see eu.qimpress.samm.usagemodel.UsagemodelPackage
 * @generated
 */
public class UsagemodelValidator extends EObjectValidator {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final UsagemodelValidator INSTANCE = new UsagemodelValidator();

	/**
	 * A constant for the {@link org.eclipse.emf.common.util.Diagnostic#getSource() source} of diagnostic {@link org.eclipse.emf.common.util.Diagnostic#getCode() codes} from this package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.common.util.Diagnostic#getSource()
	 * @see org.eclipse.emf.common.util.Diagnostic#getCode()
	 * @generated
	 */
	public static final String DIAGNOSTIC_SOURCE = "eu.qimpress.samm.usagemodel";

	/**
	 * The {@link org.eclipse.emf.common.util.Diagnostic#getCode() code} for constraint 'Called Interface Port Is AProvided Interface Port' of 'System Call'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final int SYSTEM_CALL__CALLED_INTERFACE_PORT_IS_APROVIDED_INTERFACE_PORT = 1;

	/**
	 * The {@link org.eclipse.emf.common.util.Diagnostic#getCode() code} for constraint 'Called Interface Port Belongs To AService' of 'System Call'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final int SYSTEM_CALL__CALLED_INTERFACE_PORT_BELONGS_TO_ASERVICE = 2;

	/**
	 * A constant with a fixed name that can be used as the base value for additional hand written constants.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 2;

	/**
	 * A constant with a fixed name that can be used as the base value for additional hand written constants in a derived class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static final int DIAGNOSTIC_CODE_COUNT = GENERATED_DIAGNOSTIC_CODE_COUNT;

	/**
	 * The cached base package validator.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IdentifierValidator identifierValidator;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public UsagemodelValidator() {
		super();
		identifierValidator = IdentifierValidator.INSTANCE;
	}

	/**
	 * Returns the package of this validator switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EPackage getEPackage() {
	  return UsagemodelPackage.eINSTANCE;
	}

	/**
	 * Calls <code>validateXXX</code> for the corresponding classifier of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
		switch (classifierID) {
			case UsagemodelPackage.CLOSED_WORKLOAD:
				return validateClosedWorkload((ClosedWorkload)value, diagnostics, context);
			case UsagemodelPackage.WORKLOAD:
				return validateWorkload((Workload)value, diagnostics, context);
			case UsagemodelPackage.USAGE_SCENARIO:
				return validateUsageScenario((UsageScenario)value, diagnostics, context);
			case UsagemodelPackage.SYSTEM_CALL:
				return validateSystemCall((SystemCall)value, diagnostics, context);
			case UsagemodelPackage.OPEN_WORKLOAD:
				return validateOpenWorkload((OpenWorkload)value, diagnostics, context);
			case UsagemodelPackage.USAGE_MODEL:
				return validateUsageModel((UsageModel)value, diagnostics, context);
			case UsagemodelPackage.USAGE_REPOSITORY:
				return validateUsageRepository((UsageRepository)value, diagnostics, context);
			default:
				return true;
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateClosedWorkload(ClosedWorkload closedWorkload, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(closedWorkload, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(closedWorkload, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(closedWorkload, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(closedWorkload, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(closedWorkload, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(closedWorkload, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(closedWorkload, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_idHasToBeUnique(closedWorkload, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateWorkload(Workload workload, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(workload, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(workload, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(workload, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(workload, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(workload, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(workload, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(workload, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_idHasToBeUnique(workload, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateUsageScenario(UsageScenario usageScenario, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(usageScenario, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(usageScenario, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(usageScenario, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(usageScenario, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(usageScenario, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(usageScenario, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(usageScenario, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_idHasToBeUnique(usageScenario, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateSystemCall(SystemCall systemCall, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(systemCall, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(systemCall, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(systemCall, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(systemCall, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(systemCall, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(systemCall, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(systemCall, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_idHasToBeUnique(systemCall, diagnostics, context);
		if (result || diagnostics != null) result &= validateSystemCall_CalledInterfacePortIsAProvidedInterfacePort(systemCall, diagnostics, context);
		if (result || diagnostics != null) result &= validateSystemCall_CalledInterfacePortBelongsToAService(systemCall, diagnostics, context);
		return result;
	}

	/**
	 * Validates the CalledInterfacePortIsAProvidedInterfacePort constraint of '<em>System Call</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateSystemCall_CalledInterfacePortIsAProvidedInterfacePort(SystemCall systemCall, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return systemCall.CalledInterfacePortIsAProvidedInterfacePort(diagnostics, context);
	}

	/**
	 * Validates the CalledInterfacePortBelongsToAService constraint of '<em>System Call</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateSystemCall_CalledInterfacePortBelongsToAService(SystemCall systemCall, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return systemCall.CalledInterfacePortBelongsToAService(diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateOpenWorkload(OpenWorkload openWorkload, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(openWorkload, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(openWorkload, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(openWorkload, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(openWorkload, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(openWorkload, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(openWorkload, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(openWorkload, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_idHasToBeUnique(openWorkload, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateUsageModel(UsageModel usageModel, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(usageModel, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(usageModel, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(usageModel, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(usageModel, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(usageModel, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(usageModel, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(usageModel, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_idHasToBeUnique(usageModel, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateUsageRepository(UsageRepository usageRepository, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(usageRepository, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(usageRepository, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(usageRepository, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(usageRepository, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(usageRepository, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(usageRepository, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(usageRepository, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_idHasToBeUnique(usageRepository, diagnostics, context);
		return result;
	}

	/**
	 * Returns the resource locator that will be used to fetch messages for this validator's diagnostics.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ResourceLocator getResourceLocator() {
		// TODO
		// Specialize this to return a resource locator for messages specific to this validator.
		// Ensure that you remove @generated or mark it @generated NOT
		return super.getResourceLocator();
	}

} //UsagemodelValidator
