/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.usagemodel.impl;

import java.util.Map;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.OCL;

import eu.qimpress.samm.core.impl.NamedEntityImpl;
import eu.qimpress.samm.staticstructure.InterfacePort;
import eu.qimpress.samm.staticstructure.Operation;
import eu.qimpress.samm.usagemodel.SystemCall;
import eu.qimpress.samm.usagemodel.UsagemodelPackage;
import eu.qimpress.samm.usagemodel.util.UsagemodelValidator;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>System Call</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link eu.qimpress.samm.usagemodel.impl.SystemCallImpl#getCalledInterfacePort <em>Called Interface Port</em>}</li>
 *   <li>{@link eu.qimpress.samm.usagemodel.impl.SystemCallImpl#getOperation <em>Operation</em>}</li>
 *   <li>{@link eu.qimpress.samm.usagemodel.impl.SystemCallImpl#getCallProbability <em>Call Probability</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SystemCallImpl extends NamedEntityImpl implements SystemCall {
	/**
	 * The cached value of the '{@link #getCalledInterfacePort() <em>Called Interface Port</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCalledInterfacePort()
	 * @generated
	 * @ordered
	 */
	protected InterfacePort calledInterfacePort;

	/**
	 * The cached value of the '{@link #getOperation() <em>Operation</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOperation()
	 * @generated
	 * @ordered
	 */
	protected Operation operation;

	/**
	 * The default value of the '{@link #getCallProbability() <em>Call Probability</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCallProbability()
	 * @generated
	 * @ordered
	 */
	protected static final double CALL_PROBABILITY_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getCallProbability() <em>Call Probability</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCallProbability()
	 * @generated
	 * @ordered
	 */
	protected double callProbability = CALL_PROBABILITY_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SystemCallImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return UsagemodelPackage.Literals.SYSTEM_CALL;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public InterfacePort getCalledInterfacePort() {
		if (calledInterfacePort != null && calledInterfacePort.eIsProxy()) {
			InternalEObject oldCalledInterfacePort = (InternalEObject)calledInterfacePort;
			calledInterfacePort = (InterfacePort)eResolveProxy(oldCalledInterfacePort);
			if (calledInterfacePort != oldCalledInterfacePort) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, UsagemodelPackage.SYSTEM_CALL__CALLED_INTERFACE_PORT, oldCalledInterfacePort, calledInterfacePort));
			}
		}
		return calledInterfacePort;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public InterfacePort basicGetCalledInterfacePort() {
		return calledInterfacePort;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCalledInterfacePort(InterfacePort newCalledInterfacePort) {
		InterfacePort oldCalledInterfacePort = calledInterfacePort;
		calledInterfacePort = newCalledInterfacePort;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, UsagemodelPackage.SYSTEM_CALL__CALLED_INTERFACE_PORT, oldCalledInterfacePort, calledInterfacePort));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Operation getOperation() {
		if (operation != null && operation.eIsProxy()) {
			InternalEObject oldOperation = (InternalEObject)operation;
			operation = (Operation)eResolveProxy(oldOperation);
			if (operation != oldOperation) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, UsagemodelPackage.SYSTEM_CALL__OPERATION, oldOperation, operation));
			}
		}
		return operation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Operation basicGetOperation() {
		return operation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOperation(Operation newOperation) {
		Operation oldOperation = operation;
		operation = newOperation;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, UsagemodelPackage.SYSTEM_CALL__OPERATION, oldOperation, operation));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getCallProbability() {
		return callProbability;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCallProbability(double newCallProbability) {
		double oldCallProbability = callProbability;
		callProbability = newCallProbability;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, UsagemodelPackage.SYSTEM_CALL__CALL_PROBABILITY, oldCallProbability, callProbability));
	}

	/**
	 * The cached OCL expression body for the '{@link #CalledInterfacePortIsAProvidedInterfacePort(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map) <em>Called Interface Port Is AProvided Interface Port</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CalledInterfacePortIsAProvidedInterfacePort(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map)
	 * @generated
	 * @ordered
	 */
	protected static final String CALLED_INTERFACE_PORT_IS_APROVIDED_INTERFACE_PORT__DIAGNOSTIC_CHAIN_MAP__EOCL_EXP = "calledInterfacePort.isRequired = false";

	/**
	 * The cached OCL invariant for the '{@link #CalledInterfacePortIsAProvidedInterfacePort(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map) <em>Called Interface Port Is AProvided Interface Port</em>}' invariant operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CalledInterfacePortIsAProvidedInterfacePort(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map)
	 * @generated
	 * @ordered
	 */
	protected static Constraint CALLED_INTERFACE_PORT_IS_APROVIDED_INTERFACE_PORT__DIAGNOSTIC_CHAIN_MAP__EOCL_INV;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean CalledInterfacePortIsAProvidedInterfacePort(DiagnosticChain diagnostics, Map<Object, Object> context) {
		if (CALLED_INTERFACE_PORT_IS_APROVIDED_INTERFACE_PORT__DIAGNOSTIC_CHAIN_MAP__EOCL_INV == null) {
			OCL.Helper helper = EOCL_ENV.createOCLHelper();
			helper.setContext(UsagemodelPackage.Literals.SYSTEM_CALL);
			try {
				CALLED_INTERFACE_PORT_IS_APROVIDED_INTERFACE_PORT__DIAGNOSTIC_CHAIN_MAP__EOCL_INV = helper.createInvariant(CALLED_INTERFACE_PORT_IS_APROVIDED_INTERFACE_PORT__DIAGNOSTIC_CHAIN_MAP__EOCL_EXP);
			}
			catch (ParserException pe) {
				throw new UnsupportedOperationException(pe.getLocalizedMessage());
			}
		}
		if (!EOCL_ENV.createQuery(CALLED_INTERFACE_PORT_IS_APROVIDED_INTERFACE_PORT__DIAGNOSTIC_CHAIN_MAP__EOCL_INV).check(this)) {
			if (diagnostics != null) {
				diagnostics.add
					(new BasicDiagnostic
						(Diagnostic.ERROR,
						 UsagemodelValidator.DIAGNOSTIC_SOURCE,
						 UsagemodelValidator.SYSTEM_CALL__CALLED_INTERFACE_PORT_IS_APROVIDED_INTERFACE_PORT,
						 EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic", new Object[] { "CalledInterfacePortIsAProvidedInterfacePort", EObjectValidator.getObjectLabel(this, context) }),
						 new Object [] { this }));
			}
			return false;
		}
		return true;
	}

	/**
	 * The cached OCL expression body for the '{@link #CalledInterfacePortBelongsToAService(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map) <em>Called Interface Port Belongs To AService</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CalledInterfacePortBelongsToAService(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map)
	 * @generated
	 * @ordered
	 */
	protected static final String CALLED_INTERFACE_PORT_BELONGS_TO_ASERVICE__DIAGNOSTIC_CHAIN_MAP__EOCL_EXP = "--calledInterfacePort.providingComponentType.oclIsTypeOf(allocation::Service)\n"+"true";

	/**
	 * The cached OCL invariant for the '{@link #CalledInterfacePortBelongsToAService(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map) <em>Called Interface Port Belongs To AService</em>}' invariant operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CalledInterfacePortBelongsToAService(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map)
	 * @generated
	 * @ordered
	 */
	protected static Constraint CALLED_INTERFACE_PORT_BELONGS_TO_ASERVICE__DIAGNOSTIC_CHAIN_MAP__EOCL_INV;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean CalledInterfacePortBelongsToAService(DiagnosticChain diagnostics, Map<Object, Object> context) {
		if (CALLED_INTERFACE_PORT_BELONGS_TO_ASERVICE__DIAGNOSTIC_CHAIN_MAP__EOCL_INV == null) {
			OCL.Helper helper = EOCL_ENV.createOCLHelper();
			helper.setContext(UsagemodelPackage.Literals.SYSTEM_CALL);
			try {
				CALLED_INTERFACE_PORT_BELONGS_TO_ASERVICE__DIAGNOSTIC_CHAIN_MAP__EOCL_INV = helper.createInvariant(CALLED_INTERFACE_PORT_BELONGS_TO_ASERVICE__DIAGNOSTIC_CHAIN_MAP__EOCL_EXP);
			}
			catch (ParserException pe) {
				throw new UnsupportedOperationException(pe.getLocalizedMessage());
			}
		}
		if (!EOCL_ENV.createQuery(CALLED_INTERFACE_PORT_BELONGS_TO_ASERVICE__DIAGNOSTIC_CHAIN_MAP__EOCL_INV).check(this)) {
			if (diagnostics != null) {
				diagnostics.add
					(new BasicDiagnostic
						(Diagnostic.ERROR,
						 UsagemodelValidator.DIAGNOSTIC_SOURCE,
						 UsagemodelValidator.SYSTEM_CALL__CALLED_INTERFACE_PORT_BELONGS_TO_ASERVICE,
						 EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic", new Object[] { "CalledInterfacePortBelongsToAService", EObjectValidator.getObjectLabel(this, context) }),
						 new Object [] { this }));
			}
			return false;
		}
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case UsagemodelPackage.SYSTEM_CALL__CALLED_INTERFACE_PORT:
				if (resolve) return getCalledInterfacePort();
				return basicGetCalledInterfacePort();
			case UsagemodelPackage.SYSTEM_CALL__OPERATION:
				if (resolve) return getOperation();
				return basicGetOperation();
			case UsagemodelPackage.SYSTEM_CALL__CALL_PROBABILITY:
				return getCallProbability();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case UsagemodelPackage.SYSTEM_CALL__CALLED_INTERFACE_PORT:
				setCalledInterfacePort((InterfacePort)newValue);
				return;
			case UsagemodelPackage.SYSTEM_CALL__OPERATION:
				setOperation((Operation)newValue);
				return;
			case UsagemodelPackage.SYSTEM_CALL__CALL_PROBABILITY:
				setCallProbability((Double)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case UsagemodelPackage.SYSTEM_CALL__CALLED_INTERFACE_PORT:
				setCalledInterfacePort((InterfacePort)null);
				return;
			case UsagemodelPackage.SYSTEM_CALL__OPERATION:
				setOperation((Operation)null);
				return;
			case UsagemodelPackage.SYSTEM_CALL__CALL_PROBABILITY:
				setCallProbability(CALL_PROBABILITY_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case UsagemodelPackage.SYSTEM_CALL__CALLED_INTERFACE_PORT:
				return calledInterfacePort != null;
			case UsagemodelPackage.SYSTEM_CALL__OPERATION:
				return operation != null;
			case UsagemodelPackage.SYSTEM_CALL__CALL_PROBABILITY:
				return callProbability != CALL_PROBABILITY_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (callProbability: ");
		result.append(callProbability);
		result.append(')');
		return result.toString();
	}

	/**
	 * The cached environment for evaluating OCL expressions.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected static final OCL EOCL_ENV = OCL.newInstance();

} //SystemCallImpl
